/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.interceptor;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SiteCookieChangeInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog(SiteCookieChangeInterceptor.class);
    protected String cookieName;

    @Required
    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            String cookieValue;
            String siteName = siteContext.getSiteName();
            if (!siteName.equals(cookieValue = HttpUtils.getCookieValue((String)this.cookieName, (HttpServletRequest)request))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting '" + this.cookieName + "' cookie to '" + siteName + "'"));
                }
                Cookie cookie = new Cookie(this.cookieName, siteName);
                cookie.setDomain(request.getServerName());
                cookie.setPath("/");
                cookie.setMaxAge(-1);
                response.addCookie(cookie);
            }
        } else {
            throw new IllegalStateException("No current site context found");
        }
    }
}

