/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.targeting.TargetIdManager;
import org.craftercms.engine.targeting.TargetedUrlComponents;
import org.craftercms.engine.targeting.TargetedUrlStrategy;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractTargetedUrlStrategy
implements TargetedUrlStrategy {
    protected TargetIdManager targetIdManager;

    @Required
    public void setTargetIdManager(TargetIdManager targetIdManager) {
        this.targetIdManager = targetIdManager;
    }

    public String toTargetedUrl(String url, boolean forceCurrentTargetId) {
        TargetedUrlComponents urlComponents;
        String currentTargetId;
        Matcher matcher = this.matchUrl(url);
        if (matcher == null) {
            String currentTargetId2 = this.targetIdManager.getCurrentTargetId();
            return this.doToTargetedUrl(url, currentTargetId2);
        }
        if (forceCurrentTargetId && !(currentTargetId = this.targetIdManager.getCurrentTargetId()).equals((urlComponents = this.getTargetedUrlComponents(matcher)).getTargetId())) {
            return this.buildTargetedUrl(urlComponents.getPrefix(), currentTargetId, urlComponents.getSuffix());
        }
        return url;
    }

    public TargetedUrlComponents parseTargetedUrl(String targetedUrl) {
        Matcher matcher = this.matchUrl(targetedUrl);
        if (matcher != null) {
            return this.getTargetedUrlComponents(matcher);
        }
        return null;
    }

    public String buildTargetedUrl(String prefix, String targetId, String suffix) {
        String targetedUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            targetedUrl = targetedUrl + prefix;
        }
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            targetedUrl = targetedUrl + targetId;
        }
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            targetedUrl = targetedUrl + suffix;
        }
        return targetedUrl;
    }

    protected Matcher matchUrl(String url) {
        Pattern pattern = this.getTargetedUrlPattern();
        Matcher matcher = pattern.matcher(url);
        if (matcher.matches()) {
            return matcher;
        }
        return null;
    }

    protected TargetedUrlComponents getTargetedUrlComponents(Matcher matcher) {
        TargetedUrlComponents urlComp = new TargetedUrlComponents();
        urlComp.setPrefix(this.getPrefix(matcher));
        urlComp.setTargetId(this.getTargetId(matcher));
        urlComp.setSuffix(this.getSuffix(matcher));
        return urlComp;
    }

    protected abstract String getPrefix(Matcher var1);

    protected abstract String getTargetId(Matcher var1);

    protected abstract String getSuffix(Matcher var1);

    protected abstract Pattern getTargetedUrlPattern();

    protected abstract String doToTargetedUrl(String var1, String var2);
}

