/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.targeting.CandidateTargetedUrlsResolver;
import org.craftercms.engine.targeting.impl.TargetedContentStoreAdapter;
import org.craftercms.engine.util.TargetingUtils;
import org.springframework.beans.factory.annotation.Required;

public class TargetedContentStoreAdapter
implements ContentStoreAdapter {
    public static final Log logger = LogFactory.getLog(TargetedContentStoreAdapter.class);
    protected ContentStoreAdapter actualAdapter;
    protected CandidateTargetedUrlsResolver candidateTargetedUrlsResolver;

    @Required
    public void setCandidateTargetedUrlsResolver(CandidateTargetedUrlsResolver candidateTargetedUrlsResolver) {
        this.candidateTargetedUrlsResolver = candidateTargetedUrlsResolver;
    }

    @Required
    public void setActualAdapter(ContentStoreAdapter actualAdapter) {
        this.actualAdapter = actualAdapter;
    }

    public Context createContext(String id, String storeServerUrl, String username, String password, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws StoreException, AuthenticationException {
        Context context = this.actualAdapter.createContext(id, storeServerUrl, username, password, rootFolderPath, mergingOn, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        return new ContextWrapper(this, context);
    }

    public boolean validate(Context context) throws StoreException, AuthenticationException {
        return this.actualAdapter.validate(((ContextWrapper)context).getActualContext());
    }

    public void destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
        context = ((ContextWrapper)context).getActualContext();
        this.actualAdapter.destroyContext(context);
    }

    public boolean exists(Context context, String path) throws InvalidContextException, StoreException {
        context = ((ContextWrapper)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath((String)path)) {
            List candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty((Collection)candidatePaths)) {
                for (String candidatePath : candidatePaths) {
                    if (!this.actualAdapter.exists(context, candidatePath)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted of " + path + " found at " + candidatePath));
                    }
                    return true;
                }
                return false;
            }
            return this.actualAdapter.exists(context, path);
        }
        return this.actualAdapter.exists(context, path);
    }

    public Content findContent(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        context = ((ContextWrapper)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath((String)path)) {
            List candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty((Collection)candidatePaths)) {
                for (String candidatePath : candidatePaths) {
                    Content content = this.actualAdapter.findContent(context, cachingOptions, candidatePath);
                    if (content == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted version of " + path + " found at " + candidatePath));
                    }
                    return content;
                }
                return null;
            }
            return this.actualAdapter.findContent(context, cachingOptions, path);
        }
        return this.actualAdapter.findContent(context, cachingOptions, path);
    }

    public Item findItem(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, XmlFileParseException, StoreException {
        context = ((ContextWrapper)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath((String)path)) {
            List candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty((Collection)candidatePaths)) {
                for (String candidatePath : candidatePaths) {
                    Item item = this.actualAdapter.findItem(context, cachingOptions, candidatePath, withDescriptor);
                    if (item == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted version of " + path + " found at " + candidatePath));
                    }
                    return item;
                }
                return null;
            }
            return this.actualAdapter.findItem(context, cachingOptions, path, withDescriptor);
        }
        return this.actualAdapter.findItem(context, cachingOptions, path, withDescriptor);
    }

    public List<Item> findItems(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, XmlFileParseException, StoreException {
        context = ((ContextWrapper)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath((String)path)) {
            List candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty((Collection)candidatePaths)) {
                if (SiteProperties.isMergeFolders()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Merging child items of " + candidatePaths));
                    }
                    List mergedItems = null;
                    for (String candidatePath : candidatePaths) {
                        List items = this.actualAdapter.findItems(context, cachingOptions, candidatePath, withDescriptor);
                        mergedItems = this.mergeItems(mergedItems, items);
                    }
                    return mergedItems;
                }
                for (String candidatePath : candidatePaths) {
                    List items = this.actualAdapter.findItems(context, cachingOptions, candidatePath, withDescriptor);
                    if (!CollectionUtils.isNotEmpty((Collection)items)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted version of " + path + " found at " + candidatePath));
                    }
                    return items;
                }
                return null;
            }
            return this.actualAdapter.findItems(context, cachingOptions, path, withDescriptor);
        }
        return this.actualAdapter.findItems(context, cachingOptions, path, withDescriptor);
    }

    protected List<Item> mergeItems(List<Item> overriding, List<Item> original) {
        if (overriding == null) {
            return original;
        }
        if (original == null) {
            return overriding;
        }
        CachingAwareList merged = new CachingAwareList(new ArrayList<Item>(overriding));
        for (Item item : original) {
            if (this.containsItem((List)merged, item)) continue;
            merged.add(item);
        }
        return merged;
    }

    protected boolean containsItem(List<Item> list, Item item) {
        int idx = ListUtils.indexOf(list, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return idx >= 0;
    }
}

