/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.targeting.impl.AbstractTargetedUrlStrategy;

public class TargetedUrlByFileStrategy
extends AbstractTargetedUrlStrategy {
    public static final String DEFAULT_TARGET_ID_SEPARATOR = "_";
    public static final String TARGETED_URL_REGEX_FORMAT = "^(.+)%s(%s)(\\.[^.]+)$";
    public static final int PREFIX_GROUP = 1;
    public static final int TARGET_ID_GROUP = 2;
    public static final int SUFFIX_GROUP = 3;
    protected String targetIdSeparator = "_";

    public void setTargetIdSeparator(String targetIdSeparator) {
        this.targetIdSeparator = targetIdSeparator;
    }

    public boolean isFileNameBasedStrategy() {
        return true;
    }

    public String buildTargetedUrl(String prefix, String targetId, String suffix) {
        String targetedUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            targetedUrl = targetedUrl + prefix;
        }
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            if (StringUtils.isNotEmpty((CharSequence)targetedUrl)) {
                targetedUrl = StringUtils.appendIfMissing((String)targetedUrl, (CharSequence)this.targetIdSeparator, (CharSequence[])new CharSequence[0]);
            }
            targetedUrl = targetedUrl + targetId;
        }
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            targetedUrl = targetedUrl + StringUtils.prependIfMissing((String)suffix, (CharSequence)".", (CharSequence[])new CharSequence[0]);
        }
        targetedUrl = StringUtils.prependIfMissing((String)targetedUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return targetedUrl;
    }

    protected String getPrefix(Matcher matcher) {
        return matcher.group(1);
    }

    protected String getTargetId(Matcher matcher) {
        return matcher.group(2);
    }

    protected String getSuffix(Matcher matcher) {
        return matcher.group(3);
    }

    protected Pattern getTargetedUrlPattern() {
        String availableTargetIds = StringUtils.join((Iterable)this.targetIdManager.getAvailableTargetIds(), (char)'|');
        String targetedUrlByFilePattern = String.format(TARGETED_URL_REGEX_FORMAT, this.targetIdSeparator, availableTargetIds);
        return Pattern.compile(targetedUrlByFilePattern);
    }

    protected String doToTargetedUrl(String url, String currentTargetId) {
        String ext = FilenameUtils.getExtension((String)url);
        if (StringUtils.isNotEmpty((CharSequence)ext)) {
            String urlWithoutExt = FilenameUtils.removeExtension((String)url);
            return this.buildTargetedUrl(urlWithoutExt, currentTargetId, ext);
        }
        return url;
    }
}

