/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl.merge;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.craftercms.core.xml.mergers.MergeableDescriptor;
import org.craftercms.core.xml.mergers.impl.strategies.InheritLevelsMergeStrategy;
import org.craftercms.engine.targeting.CandidateTargetedUrlsResolver;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Required;

public class TargetedContentDescriptorMergeStrategy
extends InheritLevelsMergeStrategy
implements DescriptorMergeStrategy {
    protected DescriptorMergeStrategyResolver mergeStrategyResolver;
    protected CandidateTargetedUrlsResolver candidateTargetedUrlsResolver;

    @Required
    public void setMergeStrategyResolver(DescriptorMergeStrategyResolver mergeStrategyResolver) {
        this.mergeStrategyResolver = mergeStrategyResolver;
    }

    @Required
    public void setCandidateTargetedUrlsResolver(CandidateTargetedUrlsResolver candidateTargetedUrlsResolver) {
        this.candidateTargetedUrlsResolver = candidateTargetedUrlsResolver;
    }

    public List<MergeableDescriptor> getDescriptors(Context context, CachingOptions cachingOptions, String mainDescriptorUrl, Document mainDescriptorDom) throws XmlMergeException {
        return this.getDescriptors(context, cachingOptions, mainDescriptorUrl, mainDescriptorDom, false);
    }

    public List<MergeableDescriptor> getDescriptors(Context context, CachingOptions cachingOptions, String mainDescriptorUrl, Document mainDescriptorDom, boolean mainDescriptorOptional) throws XmlMergeException {
        LinkedHashSet results = new LinkedHashSet();
        List candidateUrls = this.candidateTargetedUrlsResolver.getUrls(mainDescriptorUrl);
        ListIterator iter = candidateUrls.listIterator(candidateUrls.size());
        while (iter.hasPrevious()) {
            Document descriptorDom;
            String candidateUrl = (String)iter.previous();
            if (candidateUrl.equals(mainDescriptorUrl) || (descriptorDom = this.getDescriptorDom(context, cachingOptions, candidateUrl)) == null) continue;
            DescriptorMergeStrategy mergeStrategy = this.mergeStrategyResolver.getStrategy(candidateUrl, descriptorDom);
            List descriptors = mergeStrategy.getDescriptors(context, cachingOptions, candidateUrl, descriptorDom, true);
            results.addAll(descriptors);
        }
        List descriptors = super.getDescriptors(context, cachingOptions, mainDescriptorUrl, mainDescriptorDom, mainDescriptorOptional);
        results.addAll(descriptors);
        return new ArrayList<MergeableDescriptor>(results);
    }

    protected Document getDescriptorDom(Context context, CachingOptions cachingOptions, String url) {
        Item item = context.getStoreAdapter().findItem(context, cachingOptions, url, true);
        if (item != null) {
            return item.getDescriptorDom();
        }
        return null;
    }
}

