/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.url;

import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.targeting.TargetedUrlStrategy;
import org.craftercms.engine.util.TargetingUtils;
import org.springframework.beans.factory.annotation.Required;

public class ToTargetedUrlTransformer
implements UrlTransformer {
    protected TargetedUrlStrategy targetedUrlStrategy;
    protected boolean forceCurrentTargetId;

    @Required
    public void setTargetedUrlStrategy(TargetedUrlStrategy targetedUrlStrategy) {
        this.targetedUrlStrategy = targetedUrlStrategy;
    }

    public void setForceCurrentTargetId(boolean forceCurrentTargetId) {
        this.forceCurrentTargetId = forceCurrentTargetId;
    }

    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        String rootFolder;
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath((String)url) && StringUtils.isNotEmpty((CharSequence)(rootFolder = TargetingUtils.getMatchingRootFolder((String)url)))) {
            String relativeUrl = StringUtils.substringAfter((String)url, (String)rootFolder);
            String targetedUrl = this.targetedUrlStrategy.toTargetedUrl(relativeUrl, this.forceCurrentTargetId);
            return UrlUtils.concat((String)rootFolder, (String)targetedUrl);
        }
        return url;
    }
}

