/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.Lookup;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigUtils {
    private ConfigUtils() {
    }

    public static HierarchicalConfiguration getCurrentConfig() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return siteContext.getConfig();
        }
        return null;
    }

    public static XMLConfiguration readXmlConfiguration(Resource resource, char listDelimiter) throws ConfigurationException {
        return ConfigUtils.readXmlConfiguration((Resource)resource, (char)listDelimiter, null);
    }

    public static XMLConfiguration readXmlConfiguration(Resource resource, char listDelimiter, Map<String, Lookup> prefixLookups) throws ConfigurationException {
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        try {
            XMLBuilderParameters xmlParams = (XMLBuilderParameters)((XMLBuilderParameters)params.xml().setURL(resource.getURL())).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(listDelimiter));
            if (MapUtils.isNotEmpty(prefixLookups)) {
                xmlParams = (XMLBuilderParameters)xmlParams.setPrefixLookups(prefixLookups);
            }
            builder.configure(new BuilderParameters[]{xmlParams});
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to get URL of resource " + resource, (Throwable)e);
        }
        return (XMLConfiguration)builder.getConfiguration();
    }
}

