/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util;

import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.impl.GroovyScript;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.spring.ApplicationContextAccessor;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroovyScriptUtils {
    public static final Logger GROOVY_SCRIPT_LOGGER = LoggerFactory.getLogger(GroovyScript.class);
    public static final String VARIABLE_APPLICATION = "application";
    public static final String VARIABLE_REQUEST = "request";
    public static final String VARIABLE_RESPONSE = "response";
    public static final String VARIABLE_PARAMS = "params";
    public static final String VARIABLE_PATH_VARS = "pathVars";
    public static final String VARIABLE_HEADERS = "headers";
    public static final String VARIABLE_COOKIES = "cookies";
    public static final String VARIABLE_SESSION = "session";
    public static final String VARIABLE_LOGGER = "logger";
    public static final String VARIABLE_LOCALE = "locale";
    @Deprecated
    public static final String VARIABLE_MODEL = "model";
    public static final String VARIABLE_TEMPLATE_MODEL = "templateModel";
    @Deprecated
    public static final String VARIABLE_CRAFTER_MODEL = "crafterModel";
    public static final String VARIABLE_CONTENT_MODEL = "contentModel";
    public static final String VARIABLE_AUTH = "authentication";
    public static final String VARIABLE_PROFILE = "profile";
    public static final String VARIABLE_SITE_CONTEXT = "siteContext";
    public static final String VARIABLE_SITE_CONFIG = "siteConfig";
    public static final String VARIABLE_FILTER_CHAIN = "filterChain";
    public static final String VARIABLE_APPLICATION_CONTEXT = "applicationContext";

    private GroovyScriptUtils() {
    }

    public static void addRestScriptVariables(Map<String, Object> variables, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        GroovyScriptUtils.addCommonVariables(variables, (HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)servletContext);
        GroovyScriptUtils.addSecurityVariables(variables);
    }

    public static void addSiteItemScriptVariables(Map<String, Object> variables, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, SiteItem item, Object templateModel) {
        GroovyScriptUtils.addCommonVariables(variables, (HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)servletContext);
        GroovyScriptUtils.addSecurityVariables(variables);
        GroovyScriptUtils.addContentModelVariable(variables, (SiteItem)item);
        GroovyScriptUtils.addTemplateModelVariable(variables, (Object)templateModel);
    }

    public static void addControllerScriptVariables(Map<String, Object> variables, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Object templateModel) {
        GroovyScriptUtils.addCommonVariables(variables, (HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)servletContext);
        GroovyScriptUtils.addSecurityVariables(variables);
        GroovyScriptUtils.addTemplateModelVariable(variables, (Object)templateModel);
    }

    public static void addFilterScriptVariables(Map<String, Object> variables, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, FilterChain filterChain) {
        GroovyScriptUtils.addCommonVariables(variables, (HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)servletContext);
        GroovyScriptUtils.addSecurityVariables(variables);
        GroovyScriptUtils.addFilterChainVariable(variables, (FilterChain)filterChain);
    }

    public static void addJobScriptVariables(Map<String, Object> variables, ServletContext servletContext) {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null && siteContext.getApplicationContext() != null) {
            ApplicationContextAccessor appContext = new ApplicationContextAccessor();
            appContext.setApplicationContext((ApplicationContext)siteContext.getApplicationContext());
            variables.put("applicationContext", appContext);
        }
        variables.put("application", servletContext);
        variables.put("logger", GROOVY_SCRIPT_LOGGER);
        GroovyScriptUtils.addSiteContextVariable(variables);
        GroovyScriptUtils.addSiteConfigVariable(variables);
    }

    private static void addCommonVariables(Map<String, Object> variables, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        variables.put("application", servletContext);
        variables.put("request", request);
        variables.put("response", response);
        if (request != null) {
            variables.put("params", HttpUtils.createRequestParamsMap((HttpServletRequest)request));
            variables.put("headers", HttpUtils.createHeadersMap((HttpServletRequest)request));
            variables.put("cookies", HttpUtils.createCookiesMap((HttpServletRequest)request));
            variables.put("session", request.getSession(false));
        } else {
            variables.put("params", null);
            variables.put("headers", null);
            variables.put("cookies", null);
            variables.put("session", null);
        }
        variables.put("logger", GROOVY_SCRIPT_LOGGER);
        variables.put("locale", LocaleContextHolder.getLocale());
        GroovyScriptUtils.addSiteContextVariable(variables);
        GroovyScriptUtils.addSiteConfigVariable(variables);
    }

    private static void addTemplateModelVariable(Map<String, Object> variables, Object model) {
        variables.put("model", model);
        variables.put("templateModel", model);
    }

    private static void addContentModelVariable(Map<String, Object> variables, SiteItem siteItem) {
        variables.put("crafterModel", siteItem);
        variables.put("contentModel", siteItem);
    }

    private static void addSecurityVariables(Map<String, Object> variables) {
        Authentication auth = SecurityUtils.getCurrentAuthentication();
        Profile profile = null;
        if (auth != null) {
            profile = auth.getProfile();
        }
        variables.put("authentication", auth);
        variables.put("profile", profile);
    }

    private static void addSiteContextVariable(Map<String, Object> variables) {
        variables.put("siteContext", SiteContext.getCurrent());
    }

    private static void addSiteConfigVariable(Map<String, Object> variables) {
        SiteContext siteContext = SiteContext.getCurrent();
        HierarchicalConfiguration config = null;
        if (siteContext != null) {
            config = siteContext.getConfig();
        }
        variables.put("siteConfig", config);
    }

    private static void addFilterChainVariable(Map<String, Object> variables, FilterChain filterChain) {
        variables.put("filterChain", filterChain);
    }
}

