/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util;

import java.util.Properties;
import javax.servlet.ServletContext;
import org.craftercms.engine.scripting.impl.ScriptJob;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.quartz.JobContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchedulingUtils {
    private static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    private static final int DEFAULT_THREAD_COUNT = 10;

    private SchedulingUtils() {
    }

    public static Trigger createCronTrigger(String triggerName, String cronExpression) {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        return trigger;
    }

    public static JobDetail createScriptJob(SiteContext siteContext, String jobName, String scriptUrl, ServletContext servletContext) {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("siteContext", (Object)siteContext);
        dataMap.put("scriptUrl", scriptUrl);
        dataMap.put("servletContext", (Object)servletContext);
        JobDetail job = JobBuilder.newJob(ScriptJob.class).withIdentity(jobName).setJobData(dataMap).build();
        return job;
    }

    public static JobContext createJobContext(SiteContext siteContext, String scriptUrl, String cronExpression, ServletContext servletContext) {
        String jobName = siteContext.getSiteName() + ":" + scriptUrl;
        JobDetail detail = SchedulingUtils.createScriptJob((SiteContext)siteContext, (String)jobName, (String)scriptUrl, (ServletContext)servletContext);
        Trigger trigger = SchedulingUtils.createCronTrigger((String)("trigger for " + jobName), (String)cronExpression);
        String description = "Job{url='" + scriptUrl + "', cron='" + cronExpression + "'}";
        return new JobContext(detail, trigger, description);
    }

    public static Scheduler createScheduler(String schedulerName) throws SchedulerException {
        Properties props = new Properties();
        props.setProperty("org.quartz.scheduler.instanceName", schedulerName);
        props.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        props.setProperty("org.quartz.threadPool.threadCount", Integer.toString(10));
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
        return schedulerFactory.getScheduler();
    }
}

