/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.config.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.config.DecryptionLookup;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class MultiResourceConfigurationBuilder
implements ConfigurationBuilder<HierarchicalConfiguration> {
    private static final Log logger = LogFactory.getLog(MultiResourceConfigurationBuilder.class);
    public static final char DEFAULT_LIST_DELIMITER = ',';
    public static final String DEFAULT_ENCRYPTED_VALUE_PREFIX = "enc";
    protected String[] configPaths;
    protected ResourceLoader resourceLoader;
    protected char configListDelimiter;
    protected String encryptedValuePrefix;
    protected TextEncryptor configDecryptor;

    public MultiResourceConfigurationBuilder(String[] configPaths, ResourceLoader resourceLoader) {
        this(configPaths, resourceLoader, ',', DEFAULT_ENCRYPTED_VALUE_PREFIX, null);
    }

    public MultiResourceConfigurationBuilder(String[] configPaths, ResourceLoader resourceLoader, TextEncryptor configDecryptor) {
        this(configPaths, resourceLoader, ',', DEFAULT_ENCRYPTED_VALUE_PREFIX, configDecryptor);
    }

    public MultiResourceConfigurationBuilder(String[] configPaths, ResourceLoader resourceLoader, char configListDelimiter, String encryptedValuePrefix, TextEncryptor configDecryptor) {
        this.configPaths = configPaths;
        this.resourceLoader = resourceLoader;
        this.configListDelimiter = configListDelimiter;
        this.encryptedValuePrefix = encryptedValuePrefix;
        this.configDecryptor = configDecryptor;
    }

    /*
     * WARNING - void declaration
     */
    public HierarchicalConfiguration getConfiguration() throws ConfigurationException {
        ArrayList<XMLConfiguration> configs = new ArrayList<XMLConfiguration>();
        logger.info((Object)"Loading XML configurations in the order in which the properties will be resolved");
        for (int i = this.configPaths.length - 1; i >= 0; --i) {
            try {
                void var4_6;
                Resource resource = this.resourceLoader.getResource(this.configPaths[i]);
                if (!resource.exists()) continue;
                Object var4_7 = null;
                if (this.configDecryptor != null) {
                    Map<String, DecryptionLookup> map = Collections.singletonMap(this.encryptedValuePrefix, new DecryptionLookup(this.configDecryptor));
                }
                XMLConfiguration config = ConfigUtils.readXmlConfiguration((Resource)resource, (char)this.configListDelimiter, (Map)var4_6);
                logger.info((Object)("XML configuration loaded from " + resource));
                configs.add(config);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to load configuration at " + this.configPaths[i], (Throwable)e);
            }
        }
        if (configs.size() > 1) {
            CombinedConfiguration combinedConfig = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
            for (Configuration configuration : configs) {
                combinedConfig.addConfiguration(configuration);
            }
            return combinedConfig;
        }
        if (configs.size() == 1) {
            return (HierarchicalConfiguration)configs.get(0);
        }
        return null;
    }

    public <E extends Event> void addEventListener(EventType<E> eventType, EventListener<? super E> listener) {
    }

    public <E extends Event> boolean removeEventListener(EventType<E> eventType, EventListener<? super E> listener) {
        return false;
    }
}

