/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.converters;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.converters.Converter;
import org.craftercms.engine.properties.SiteProperties;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public class ElementSuffixBasedConverter
implements Converter<Element, Object> {
    private static final Log logger = LogFactory.getLog(ElementSuffixBasedConverter.class);
    public static final String[] DEFAULT_SUPPORTED_SUFFIXES_ON_DISABLED_FULL_MODEL_CONVERSION = new String[]{"i", "l", "b", "f", "d"};
    protected Map<String, Converter<String, ?>> suffixMappedConverters;
    protected String[] supportedSuffixesOnDisabledFullModelTypeConversion = DEFAULT_SUPPORTED_SUFFIXES_ON_DISABLED_FULL_MODEL_CONVERSION;

    @Required
    public void setSuffixMappedConverters(Map<String, Converter<String, ?>> suffixMappedConverters) {
        this.suffixMappedConverters = suffixMappedConverters;
    }

    public void setSupportedSuffixesOnDisabledFullModelTypeConversion(String[] supportedSuffixesOnDisabledFullModelTypeConversion) {
        this.supportedSuffixesOnDisabledFullModelTypeConversion = supportedSuffixesOnDisabledFullModelTypeConversion;
    }

    public Class<?> getSourceClass() {
        return Element.class;
    }

    public Class<?> getTargetClass() {
        return Object.class;
    }

    public Object convert(Element source) {
        String name = source.getName();
        int converterIdSuffixSepIdx = name.lastIndexOf("_");
        if (converterIdSuffixSepIdx >= 0) {
            String converterId = name.substring(converterIdSuffixSepIdx + 1);
            Converter converter = (Converter)this.suffixMappedConverters.get(converterId);
            if (converter != null) {
                if (!SiteProperties.isDisableFullModelTypeConversion() || ArrayUtils.contains((Object[])this.supportedSuffixesOnDisabledFullModelTypeConversion, (Object)converterId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Converting value of <" + name + "> to " + converter.getTargetClass().getName()));
                    }
                    return converter.convert((Object)source.getText());
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("No converter found for suffix '" + converterId + "' for <" + name + ">"));
            }
        }
        return source;
    }
}

