/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.freemarker;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpRequestHashModel
implements TemplateHashModelEx {
    public static final String KEY_SCHEME = "scheme";
    public static final String KEY_SERVER_NAME = "serverName";
    public static final String KEY_SERVER_PORT = "serverPort";
    public static final String KEY_CONTEXT_PATH = "contextPath";
    public static final String KEY_SERVLET_PATH = "servletPath";
    public static final String KEY_REQUEST_URI = "requestURI";
    public static final String KEY_QUERY_STRING = "queryString";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ObjectWrapper wrapper;

    public HttpRequestHashModel(HttpServletRequest request, ObjectWrapper wrapper) {
        this(request, null, wrapper);
    }

    public HttpRequestHashModel(HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        this.request = request;
        this.response = response;
        this.wrapper = wrapper;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        switch (key) {
            case "scheme": {
                return this.wrapper.wrap((Object)this.request.getScheme());
            }
            case "serverName": {
                return this.wrapper.wrap((Object)this.request.getServerName());
            }
            case "serverPort": {
                return this.wrapper.wrap((Object)this.request.getServerPort());
            }
            case "contextPath": {
                return this.wrapper.wrap((Object)this.request.getContextPath());
            }
            case "servletPath": {
                return this.wrapper.wrap((Object)this.request.getServletPath());
            }
            case "requestURI": {
                return this.wrapper.wrap((Object)this.request.getRequestURI());
            }
            case "queryString": {
                return this.wrapper.wrap((Object)this.request.getQueryString());
            }
        }
        return this.wrapper.wrap(this.request.getAttribute(key));
    }

    public boolean isEmpty() {
        return !this.request.getAttributeNames().hasMoreElements();
    }

    public int size() {
        int result = 0;
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++result;
        }
        return result;
    }

    public TemplateCollectionModel keys() {
        ArrayList keys = new ArrayList();
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            keys.add(enumeration.nextElement());
        }
        return new SimpleCollection(keys.iterator(), this.wrapper);
    }

    public TemplateCollectionModel values() {
        ArrayList<Object> values = new ArrayList<Object>();
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            values.add(this.request.getAttribute((String)enumeration.nextElement()));
        }
        return new SimpleCollection(values.iterator(), this.wrapper);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ObjectWrapper getObjectWrapper() {
        return this.wrapper;
    }
}

