/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.groovy;

import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.net.URLConnection;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.url.ContentStoreUrlStreamHandler;

public class ContentStoreResourceConnector
implements ResourceConnector {
    protected ContentStoreUrlStreamHandler urlStreamHandler;

    public ContentStoreResourceConnector(SiteContext siteContext) {
        this.urlStreamHandler = new ContentStoreUrlStreamHandler(siteContext);
    }

    public URLConnection getResourceConnection(String name) throws ResourceException {
        try {
            return this.urlStreamHandler.createUrl(name).openConnection();
        }
        catch (Exception e) {
            throw new ResourceException("Unable to open URL connection to '" + name + "'", (Throwable)e);
        }
    }
}

