/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.logging;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.craftercms.engine.service.context.SiteContext;

public class CircularQueueLogAppender
extends AppenderSkeleton {
    private Buffer buffer;
    private static CircularQueueLogAppender instance;
    private int maxQueueSize;
    private SimpleDateFormat dateFormat;
    private String dateFormatString;

    protected void append(LoggingEvent event) {
        SiteContext ctx = SiteContext.getCurrent();
        if (ctx != null) {
            String siteName = ctx.getSiteName();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{siteName})) {
                HashMap<String, Object> mappy = new HashMap<String, Object>();
                mappy.put("site", siteName);
                mappy.put("level", event.getLevel().toString());
                mappy.put("message", event.getRenderedMessage());
                mappy.put("thread", event.getThreadName());
                mappy.put("exception", this.subAppend(event));
                mappy.put("timestamp", this.dateFormat.format(new Date(event.getTimeStamp())));
                mappy.put("timestampm", event.getTimeStamp());
                this.buffer.add(mappy);
            }
        }
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.maxQueueSize <= 0) {
            throw new IllegalArgumentException("maxQueueSize must be a integer bigger that 0");
        }
        this.buffer = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(this.maxQueueSize));
        instance = this;
        this.dateFormat = new SimpleDateFormat(this.dateFormatString);
    }

    public void close() {
        this.buffer.clear();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormatString = dateFormat;
    }

    public static CircularQueueLogAppender loggerQueue() {
        return instance;
    }

    public List<HashMap<String, Object>> getLoggedEvents(String siteId, long since) {
        Iterator iter = this.buffer.iterator();
        ArrayList<HashMap<String, Object>> str = new ArrayList<HashMap<String, Object>>();
        while (iter.hasNext()) {
            HashMap map = (HashMap)iter.next();
            if (!map.get("site").toString().equalsIgnoreCase(siteId) || !new Date((Long)map.get("timestampm")).after(new Date(since))) continue;
            str.add(map);
        }
        return str;
    }

    protected String subAppend(LoggingEvent event) {
        StringBuffer buffer = new StringBuffer();
        if (this.layout.ignoresThrowable()) {
            buffer.append(Layout.LINE_SEP);
            String[] s = event.getThrowableStrRep();
            if (s != null) {
                int len = s.length;
                for (int i = 0; i < len; ++i) {
                    buffer.append(s[i]);
                    buffer.append(Layout.LINE_SEP);
                }
            }
        }
        return buffer.toString();
    }
}

