/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring;

import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextAccessor
implements ApplicationContextAware {
    private ApplicationContext defaultApplicationContext;

    public ApplicationContextAccessor() {
    }

    public ApplicationContextAccessor(ApplicationContext defaultApplicationContext) {
        this.defaultApplicationContext = defaultApplicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.defaultApplicationContext = applicationContext;
    }

    public Object get(String beanName) {
        return this.getApplicationContext().getBean(beanName);
    }

    public <T> T get(String beanName, Class<T> requiredType) {
        return (T)this.getApplicationContext().getBean(beanName, requiredType);
    }

    protected ApplicationContext getApplicationContext() {
        ConfigurableApplicationContext applicationContext;
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null && (applicationContext = siteContext.getApplicationContext()) != null) {
            return applicationContext;
        }
        return this.defaultApplicationContext;
    }
}

