/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.mvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class AnnotationDrivenConfigCustomizer
implements BeanPostProcessor {
    private ContentNegotiationManager contentNegotiationManager;
    private List<HttpMessageConverter<?>> messageConverters;
    private List<Object> interceptors;

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setInterceptors(List<Object> interceptors) {
        this.interceptors = interceptors;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RequestMappingHandlerAdapter) {
            RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)bean;
            if (this.contentNegotiationManager != null) {
                adapter.setContentNegotiationManager(this.contentNegotiationManager);
            }
            if (CollectionUtils.isNotEmpty((Collection)this.messageConverters)) {
                ArrayList mergedConverters = new ArrayList(this.messageConverters);
                mergedConverters.addAll(adapter.getMessageConverters());
                adapter.setMessageConverters(mergedConverters);
            }
        } else if (bean instanceof RequestMappingHandlerMapping) {
            RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)bean;
            if (CollectionUtils.isNotEmpty((Collection)this.interceptors)) {
                mapping.setInterceptors(this.interceptors.toArray(new Object[this.interceptors.size()]));
            }
        } else if (bean instanceof ExceptionHandlerExceptionResolver) {
            ExceptionHandlerExceptionResolver exceptionResolver = (ExceptionHandlerExceptionResolver)bean;
            if (this.contentNegotiationManager != null) {
                exceptionResolver.setContentNegotiationManager(this.contentNegotiationManager);
            }
            if (CollectionUtils.isNotEmpty((Collection)this.messageConverters)) {
                ArrayList mergedConverters = new ArrayList(this.messageConverters);
                mergedConverters.addAll(exceptionResolver.getMessageConverters());
                exceptionResolver.setMessageConverters(mergedConverters);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

