/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.social;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.config.ConfigurationParser;
import org.craftercms.engine.util.config.impl.FacebookConnectionFactoryConfigParser;
import org.craftercms.engine.util.spring.social.ConfigAwareConnectionFactoryLocator;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;

public class ConfigAwareConnectionFactoryLocator
implements ConnectionFactoryLocator {
    public static final String SOCIAL_CONNECTIONS_KEY = "socialConnections";
    public static final String CONNECTION_FACTORY_LOCATOR_CACHE_KEY = "connectionFactoryLocator";
    protected ConnectionFactoryLocator defaultLocator;
    protected CacheTemplate cacheTemplate;
    protected List<ConfigurationParser<?>> configParsers = new ArrayList(1);

    public ConfigAwareConnectionFactoryLocator() {
        this.configParsers.add(new FacebookConnectionFactoryConfigParser());
    }

    @Required
    public void setDefaultLocator(ConnectionFactoryLocator defaultLocator) {
        this.defaultLocator = defaultLocator;
    }

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setConfigParsers(List<ConfigurationParser<?>> configParsers) {
        this.configParsers = configParsers;
    }

    public ConnectionFactory<?> getConnectionFactory(String providerId) {
        return this.getCurrentConnectionFactoryLocator().getConnectionFactory(providerId);
    }

    public <A> ConnectionFactory<A> getConnectionFactory(Class<A> apiType) {
        return this.getCurrentConnectionFactoryLocator().getConnectionFactory(apiType);
    }

    public Set<String> registeredProviderIds() {
        return this.getCurrentConnectionFactoryLocator().registeredProviderIds();
    }

    protected ConnectionFactoryLocator getCurrentConnectionFactoryLocator() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return (ConnectionFactoryLocator)this.cacheTemplate.getObject(siteContext.getContext(), (Callback)callback, new Object[]{CONNECTION_FACTORY_LOCATOR_CACHE_KEY});
        }
        return this.defaultLocator;
    }
}

