/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.craftercms.core.service.Content;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContentStoreUrlConnection
extends URLConnection {
    private static final String CONTENT_LENGTH = "content-length";
    private static final String CONTENT_TYPE = "content-type";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String TIMEZONE = "GMT";
    protected Content content;
    protected Map<String, String> headers;
    protected String contentType;
    protected long length;
    protected long lastModified;
    protected InputStream is;
    protected boolean connected;
    protected boolean initializedHeaders;

    public ContentStoreUrlConnection(URL url, Content content) {
        super(url);
        this.content = content;
        this.headers = new LinkedHashMap();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.is = this.content.getInputStream();
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.is;
    }

    protected void initializeHeaders() {
        if (!this.initializedHeaders) {
            this.length = this.content.getLength();
            this.lastModified = this.content.getLastModified();
            FileNameMap map = ContentStoreUrlConnection.getFileNameMap();
            this.contentType = map.getContentTypeFor(this.url.getFile());
            if (this.contentType != null) {
                this.headers.put("content-type", this.contentType);
            }
            this.headers.put("content-length", String.valueOf(this.length));
            Date date = new Date(this.lastModified);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.headers.put("last-modified", dateFormat.format(date));
            this.initializedHeaders = true;
        }
    }

    @Override
    public String getHeaderField(String name) {
        this.initializeHeaders();
        return (String)this.headers.get(name);
    }

    @Override
    public String getHeaderField(int n) {
        this.initializeHeaders();
        Collection values = this.headers.values();
        String[] valuesArray = values.toArray(new String[values.size()]);
        return valuesArray[n];
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        Set keys = this.headers.keySet();
        String[] keysArray = keys.toArray(new String[keys.size()]);
        return keysArray[n];
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        return (int)this.length;
    }

    @Override
    public long getLastModified() {
        this.initializeHeaders();
        return this.lastModified;
    }
}

