/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.url;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.service.Content;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.url.ContentStoreUrlConnection;

public class ContentStoreUrlStreamHandler
extends URLStreamHandler {
    private static final String URL_REGEX = "[^:]+:.+";
    private static final String URL_SCHEME = "site";
    protected SiteContext siteContext;

    public ContentStoreUrlStreamHandler(SiteContext siteContext) {
        this.siteContext = siteContext;
    }

    public URL createUrl(String filename) throws MalformedURLException {
        if (!filename.matches(URL_REGEX)) {
            filename = "site:" + (!filename.startsWith("/") ? "/" : "") + filename;
        }
        return new URL(null, filename, (URLStreamHandler)this);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        try {
            Content content = this.siteContext.getStoreService().getContent(this.siteContext.getContext(), url.getFile());
            return new ContentStoreUrlConnection(url, content);
        }
        catch (PathNotFoundException e) {
            throw new FileNotFoundException("No content found at '" + url.getFile() + "' in content store");
        }
        catch (Exception e) {
            throw new IOException("Error retrieving content at '" + url.getFile() + "' in content store", e);
        }
    }
}

