/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.util.ExceptionUtils;
import org.craftercms.core.util.cache.CachingAwareObject;
import org.craftercms.engine.exception.HttpStatusCodeAwareException;
import org.craftercms.engine.exception.RenderingException;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.AbstractView;

public class CrafterPageView
extends AbstractView
implements CachingAwareObject,
InitializingBean {
    private static final Log logger = LogFactory.getLog(CrafterPageView.class);
    public static final String PAGE_URL_ATTRIBUTE_NAME = "pageUrl";
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String DEFAULT_CHARSET = "UTF-8";
    @Deprecated
    public static final String KEY_MODEL = "model";
    public static final String KEY_CONTENT_MODEL = "contentModel";
    protected transient String scope;
    protected transient Object key;
    protected transient List<Object> dependencyKeys;
    protected transient Long cachingTime;
    protected SiteItem page;
    protected Locale locale;
    protected SiteItemService siteItemService;
    protected String pageViewNameXPathQuery;
    protected String mimeTypeXPathQuery;
    protected List<Script> scripts;
    protected ViewResolver delegatedViewResolver;

    public SiteItem getPage() {
        return this.page;
    }

    @Required
    public void setPage(SiteItem page) {
        this.page = page;
    }

    @Required
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setPageViewNameXPathQuery(String pageViewNameXPathQuery) {
        this.pageViewNameXPathQuery = pageViewNameXPathQuery;
    }

    @Required
    public void setMimeTypeXPathQuery(String mimeTypeXPathQuery) {
        this.mimeTypeXPathQuery = mimeTypeXPathQuery;
    }

    @Required
    public void setScripts(List<Script> scripts) {
        this.scripts = scripts;
    }

    @Required
    public void setDelegatedViewResolver(ViewResolver delegatedViewResolver) {
        this.delegatedViewResolver = delegatedViewResolver;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public List<Object> getDependencyKeys() {
        return this.dependencyKeys;
    }

    public void setDependencyKeys(List<Object> dependencyKeys) {
        this.dependencyKeys = dependencyKeys;
    }

    public void addDependencyKeys(Collection<Object> dependencyKeys) {
        if (this.dependencyKeys == null) {
            this.dependencyKeys = new ArrayList();
        }
        this.dependencyKeys.addAll(dependencyKeys);
    }

    public void addDependencyKey(Object dependencyKey) {
        if (this.dependencyKeys == null) {
            this.dependencyKeys = new ArrayList();
        }
        this.dependencyKeys.add(dependencyKey);
    }

    public boolean removeDependencyKeys(Collection<Object> dependencyKeys) {
        if (this.dependencyKeys != null) {
            return this.dependencyKeys.removeAll(dependencyKeys);
        }
        return false;
    }

    public boolean removeDependencyKey(Object dependencyKey) {
        if (this.dependencyKeys != null) {
            return this.dependencyKeys.remove(dependencyKey);
        }
        return false;
    }

    public Long getCachingTime() {
        return this.cachingTime;
    }

    public void setCachingTime(Long cachingTime) {
        this.cachingTime = cachingTime;
    }

    public String toString() {
        return "CrafterPageView[page=" + this.page + ", locale=" + this.locale + ']';
    }

    public void afterPropertiesSet() throws Exception {
        String mimeType = this.getMimeType();
        if (StringUtils.isNotEmpty((CharSequence)mimeType)) {
            this.setContentType(MediaType.parseMediaType((String)mimeType).toString() + ";charset=" + DEFAULT_CHARSET);
        } else {
            this.setContentType(DEFAULT_CONTENT_TYPE);
        }
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute(PAGE_URL_ATTRIBUTE_NAME, (Object)this.page.getStoreUrl());
        Map scriptVariables = this.createScriptVariables(request, response, model);
        if (CollectionUtils.isNotEmpty((Collection)this.scripts)) {
            for (Script script : this.scripts) {
                this.executeScript(script, scriptVariables);
                if (!response.isCommitted()) continue;
                logger.debug((Object)"Response already committed by script");
                return;
            }
        }
        model.put(KEY_MODEL, this.page);
        model.put(KEY_CONTENT_MODEL, this.page);
        this.renderActualView(this.getPageViewName(), model, request, response);
    }

    protected void executeScript(Script script, Map<String, Object> scriptVariables) throws Exception {
        try {
            script.execute(scriptVariables);
        }
        catch (Exception e) {
            logger.error((Object)("Error executing page script at " + script.getUrl()), (Throwable)e);
            Exception cause = (Exception)ExceptionUtils.getThrowableOfType((Throwable)e, HttpStatusCodeAwareException.class);
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
    }

    protected Map<String, Object> createScriptVariables(HttpServletRequest request, HttpServletResponse response, Map<String, Object> model) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        GroovyScriptUtils.addSiteItemScriptVariables(variables, (HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)this.getServletContext(), (SiteItem)this.page, model);
        return variables;
    }

    protected String getPageViewName() throws RenderingException {
        String pageViewName = this.page.getItem().queryDescriptorValue(this.pageViewNameXPathQuery);
        if (StringUtils.isNotEmpty((CharSequence)pageViewName)) {
            return pageViewName;
        }
        throw new RenderingException("No view name found for " + this.page);
    }

    protected String getMimeType() {
        return this.page.getItem().queryDescriptorValue(this.mimeTypeXPathQuery);
    }

    protected void renderActualView(String pageViewName, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        View actualView = this.delegatedViewResolver.resolveViewName(pageViewName, this.locale);
        if (actualView == null) {
            throw new RenderingException("No view was resolved for page view name '" + pageViewName + "'");
        }
        if (actualView instanceof AbstractView) {
            ((AbstractView)actualView).setContentType(this.getContentType());
        }
        actualView.render(model, request, response);
    }
}

