/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.mobile.UserAgentTemplateDetector;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.SiteItemScriptResolver;
import org.craftercms.engine.security.CrafterPageAccessManager;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.UrlTransformationService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.view.CrafterPageView;
import org.craftercms.engine.view.UserAgentAwareCrafterPageView;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.Ordered;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.RedirectView;

public class CrafterPageViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    private static final String PAGE_CONST_KEY_ELEM = "page";
    private static final Log logger = LogFactory.getLog(CrafterPageViewResolver.class);
    protected int order = 10;
    protected boolean cacheUrlTransformations;
    protected String renderUrlToStoreUrlTransformerName;
    protected String storeUrlToRenderUrlTransformerName;
    protected String toFullHttpsUrlTransformerName;
    protected UrlTransformationService urlTransformationService;
    protected CacheTemplate cacheTemplate;
    protected CachingOptions cachingOptions = CachingOptions.DEFAULT_CACHING_OPTIONS;
    protected SiteItemService siteItemService;
    protected String pageViewNameXPathQuery;
    protected String redirectUrlXPathQuery;
    protected String contentTypeXPathQuery;
    protected String redirectContentType;
    protected String disabledXPathQuery;
    protected String mimeTypeXPathQuery;
    protected String forceHttpsXPathQuery;
    protected SiteItemScriptResolver scriptResolver;
    protected ViewResolver delegatedViewResolver;
    protected UserAgentTemplateDetector userAgentTemplateDetector;
    protected CrafterPageAccessManager accessManager;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setCacheUrlTransformations(boolean cacheUrlTransformations) {
        this.cacheUrlTransformations = cacheUrlTransformations;
    }

    @Required
    public void setRenderUrlToStoreUrlTransformerName(String renderUrlToStoreUrlTransformerName) {
        this.renderUrlToStoreUrlTransformerName = renderUrlToStoreUrlTransformerName;
    }

    @Required
    public void setStoreUrlToRenderUrlTransformerName(String storeUrlToRenderUrlTransformerName) {
        this.storeUrlToRenderUrlTransformerName = storeUrlToRenderUrlTransformerName;
    }

    @Required
    public void setToFullHttpsUrlTransformerName(String toFullHttpsUrlTransformerName) {
        this.toFullHttpsUrlTransformerName = toFullHttpsUrlTransformerName;
    }

    @Required
    public void setUrlTransformationService(UrlTransformationService urlTransformationService) {
        this.urlTransformationService = urlTransformationService;
    }

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setCachingOptions(CachingOptions cachingOptions) {
        this.cachingOptions = cachingOptions;
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setPageViewNameXPathQuery(String pageViewNameXPathQuery) {
        this.pageViewNameXPathQuery = pageViewNameXPathQuery;
    }

    @Required
    public void setRedirectUrlXPathQuery(String redirectUrlXPathQuery) {
        this.redirectUrlXPathQuery = redirectUrlXPathQuery;
    }

    @Required
    public void setContentTypeXPathQuery(String contentTypeXPathQuery) {
        this.contentTypeXPathQuery = contentTypeXPathQuery;
    }

    @Required
    public void setRedirectContentType(String redirectContentType) {
        this.redirectContentType = redirectContentType;
    }

    @Required
    public void setDisabledXPathQuery(String disabledXPathQuery) {
        this.disabledXPathQuery = disabledXPathQuery;
    }

    @Required
    public void setMimeTypeXPathQuery(String mimeTypeXPathQuery) {
        this.mimeTypeXPathQuery = mimeTypeXPathQuery;
    }

    @Required
    public void setScriptResolver(SiteItemScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    @Required
    public void setForceHttpsXPathQuery(String forceHttpsXPathQuery) {
        this.forceHttpsXPathQuery = forceHttpsXPathQuery;
    }

    @Required
    public void setDelegatedViewResolver(ViewResolver delegatedViewResolver) {
        this.delegatedViewResolver = delegatedViewResolver;
    }

    @Required
    public void setUserAgentTemplateDetector(UserAgentTemplateDetector userAgentTemplateDetector) {
        this.userAgentTemplateDetector = userAgentTemplateDetector;
    }

    @Required
    public void setAccessManager(CrafterPageAccessManager accessManager) {
        this.accessManager = accessManager;
    }

    public View resolveViewName(String renderUrl, Locale locale) {
        String storeUrl = this.urlTransformationService.transform(this.renderUrlToStoreUrlTransformerName, renderUrl, this.cacheUrlTransformations);
        View view = this.getCachedLocalizedView(storeUrl, locale);
        if (view instanceof CrafterPageView) {
            CrafterPageView pageView = (CrafterPageView)view;
            if (SiteProperties.isRedirectToTargetedUrl()) {
                String finalStoreUrl = pageView.getPage().getStoreUrl();
                String finalRenderUrl = this.urlTransformationService.transform(this.storeUrlToRenderUrlTransformerName, finalStoreUrl, this.cacheUrlTransformations);
                if (!(renderUrl = FilenameUtils.normalizeNoEndSeparator((String)renderUrl)).equals(finalRenderUrl = FilenameUtils.normalizeNoEndSeparator((String)finalRenderUrl))) {
                    return this.getRedirectView(finalRenderUrl, true);
                }
            }
            this.accessManager.checkAccess(pageView.getPage());
        }
        return view;
    }

    protected SiteItem getPage(String url) {
        SiteItem page = this.siteItemService.getSiteItem(url);
        if (page == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Crafter page descriptor not found at " + url));
        }
        return page;
    }

    protected View getRedirectView(String redirectUrl, boolean relative) {
        RedirectView view = new RedirectView(redirectUrl, relative, true);
        return this.applyLifecycleMethods("redirect:" + redirectUrl, (View)view);
    }

    protected View getCurrentPageHttpsRedirectView() {
        String currentUrl = RequestContext.getCurrent().getRequest().getRequestURI();
        String fullHttpsUrl = this.urlTransformationService.transform(this.toFullHttpsUrlTransformerName, currentUrl);
        return this.getRedirectView(fullHttpsUrl, false);
    }

    protected View getCachedLocalizedView(String url, Locale locale) {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return (View)this.cacheTemplate.getObject(siteContext.getContext(), this.cachingOptions, () -> {
                SiteItem page = this.getPage(url);
                if (page != null) {
                    String redirectUrl = page.getItem().queryDescriptorValue(this.redirectUrlXPathQuery);
                    String contentType = page.getItem().queryDescriptorValue(this.contentTypeXPathQuery);
                    String forceHttps = page.getItem().queryDescriptorValue(this.forceHttpsXPathQuery);
                    if (StringUtils.isNotEmpty((CharSequence)contentType) && StringUtils.equalsIgnoreCase((CharSequence)this.redirectContentType, (CharSequence)contentType) && StringUtils.isNotEmpty((CharSequence)redirectUrl)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Redirecting page @ " + url + " to URL " + redirectUrl));
                        }
                        return this.getRedirectView(redirectUrl, true);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)forceHttps) && Boolean.parseBoolean(forceHttps)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Forcing HTTPS on page @ " + url));
                        }
                        return this.getCurrentPageHttpsRedirectView();
                    }
                    UserAgentAwareCrafterPageView view = new UserAgentAwareCrafterPageView();
                    view.setServletContext(this.getServletContext());
                    view.setPage(page);
                    view.setLocale(locale);
                    view.setSiteItemService(this.siteItemService);
                    view.setPageViewNameXPathQuery(this.pageViewNameXPathQuery);
                    view.setMimeTypeXPathQuery(this.mimeTypeXPathQuery);
                    view.setDelegatedViewResolver(this.delegatedViewResolver);
                    view.setUserAgentTemplateDetector(this.userAgentTemplateDetector);
                    this.loadScripts(siteContext.getScriptFactory(), page, (CrafterPageView)view);
                    view.addDependencyKey(page.getItem().getKey());
                    return this.applyLifecycleMethods(page.getStoreUrl(), (View)view);
                }
                return null;
            }, new Object[]{url, locale, PAGE_CONST_KEY_ELEM});
        }
        return null;
    }

    protected void loadScripts(ScriptFactory scriptFactory, SiteItem page, CrafterPageView view) {
        List scriptUrls;
        if (scriptFactory != null && CollectionUtils.isNotEmpty((Collection)(scriptUrls = this.scriptResolver.getScriptUrls(page)))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Scripts associated to page " + page.getStoreUrl() + ": " + scriptUrls));
            }
            ArrayList<Script> scripts = new ArrayList<Script>(scriptUrls.size());
            for (String scriptUrl : scriptUrls) {
                Script script = scriptFactory.getScript(scriptUrl);
                scripts.add(script);
                view.addDependencyKey(script.getKey());
            }
            view.setScripts(scripts);
        }
    }

    protected View applyLifecycleMethods(String viewName, View view) {
        return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
    }
}

