/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.view.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateHashModel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.engine.freemarker.ExecuteControllerDirective;
import org.craftercms.engine.freemarker.RenderComponentDirective;
import org.craftercms.engine.freemarker.ServletContextHashModel;
import org.craftercms.engine.scripting.SiteItemScriptResolver;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.freemarker.HttpRequestHashModel;
import org.craftercms.engine.util.spring.ApplicationContextAccessor;
import org.craftercms.engine.view.freemarker.AllHttpScopesAndAppContextHashModel;
import org.craftercms.engine.view.freemarker.CrafterFreeMarkerView;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class CrafterFreeMarkerView
extends FreeMarkerView {
    public static final String RENDER_COMPONENT_DIRECTIVE_NAME = "renderComponent";
    public static final String EXECUTE_CONTROLLER_DIRECTIVE_NAME = "controller";
    public static final String KEY_APPLICATION_CAP = "Application";
    public static final String KEY_APPLICATION = "application";
    public static final String KEY_SESSION_CAP = "Session";
    public static final String KEY_SESSION = "session";
    public static final String KEY_REQUEST_CAP = "Request";
    public static final String KEY_REQUEST = "request";
    public static final String KEY_REQUEST_PARAMS_CAP = "RequestParameters";
    public static final String KEY_REQUEST_PARAMS = "requestParameters";
    public static final String KEY_APP_CONTEXT_CAP = "ApplicationContext";
    public static final String KEY_APP_CONTEXT = "applicationContext";
    public static final String KEY_COOKIES_CAP = "Cookies";
    public static final String KEY_COOKIES = "cookies";
    public static final String KEY_AUTH_CAP = "Authentication";
    public static final String KEY_AUTH = "authentication";
    public static final String KEY_PROFILE_CAP = "Profile";
    public static final String KEY_PROFILE = "profile";
    public static final String KEY_STATICS_CAP = "Statics";
    public static final String KEY_STATICS = "statics";
    public static final String KEY_ENUMS_CAP = "Enums";
    public static final String KEY_ENUMS = "enums";
    public static final String KEY_SITE_CONTEXT = "siteContext";
    public static final String KEY_SITE_CONTEXT_CAP = "SiteContext";
    public static final String KEY_SITE_CONFIG = "siteConfig";
    public static final String KEY_SITE_CONFIG_CAP = "SiteConfig";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_LOCALE_CAP = "Locale";
    protected SiteItemService siteItemService;
    protected String componentTemplateXPathQuery;
    protected String componentTemplateNamePrefix;
    protected String componentTemplateNameSuffix;
    protected String componentIncludeElementName;
    protected SiteItemScriptResolver componentScriptResolver;
    protected ServletContextHashModel servletContextHashModel;
    protected ApplicationContextAccessor applicationContextAccessor;

    protected void initServletContext(ServletContext servletContext) throws BeansException {
        super.initServletContext(servletContext);
        this.servletContextHashModel = new ServletContextHashModel(servletContext, this.getObjectWrapper());
        this.applicationContextAccessor = new ApplicationContextAccessor(this.getApplicationContext());
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setComponentTemplateXPathQuery(String componentTemplateXPathQuery) {
        this.componentTemplateXPathQuery = componentTemplateXPathQuery;
    }

    @Required
    public void setComponentTemplateNamePrefix(String componentTemplateNamePrefix) {
        this.componentTemplateNamePrefix = componentTemplateNamePrefix;
    }

    @Required
    public void setComponentTemplateNameSuffix(String componentTemplateNameSuffix) {
        this.componentTemplateNameSuffix = componentTemplateNameSuffix;
    }

    @Required
    public void setComponentIncludeElementName(String componentIncludeElementName) {
        this.componentIncludeElementName = componentIncludeElementName;
    }

    @Required
    public void setComponentScriptResolver(SiteItemScriptResolver componentScriptResolver) {
        this.componentScriptResolver = componentScriptResolver;
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return siteContext.getFreeMarkerConfig();
        }
        return super.autodetectConfiguration();
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        AllHttpScopesAndAppContextHashModel templateModel = new AllHttpScopesAndAppContextHashModel(this.getObjectWrapper(), this.applicationContextAccessor, this.getServletContext(), request);
        HttpSessionHashModel sessionModel = this.createSessionModel(request, response);
        HttpRequestHashModel requestModel = new HttpRequestHashModel(request, response, this.getObjectWrapper());
        HttpRequestParametersHashModel requestParamsModel = new HttpRequestParametersHashModel(request);
        Map cookies = this.createCookieMap(request);
        templateModel.put(KEY_APPLICATION_CAP, (Object)this.servletContextHashModel);
        templateModel.put(KEY_APPLICATION, (Object)this.servletContextHashModel);
        templateModel.put(KEY_SESSION_CAP, (Object)sessionModel);
        templateModel.put(KEY_SESSION, (Object)sessionModel);
        templateModel.put(KEY_REQUEST_CAP, (Object)requestModel);
        templateModel.put(KEY_REQUEST, (Object)requestModel);
        templateModel.put(KEY_REQUEST_PARAMS_CAP, (Object)requestParamsModel);
        templateModel.put(KEY_REQUEST_PARAMS, (Object)requestParamsModel);
        templateModel.put(KEY_APP_CONTEXT_CAP, (Object)this.applicationContextAccessor);
        templateModel.put(KEY_APP_CONTEXT, (Object)this.applicationContextAccessor);
        templateModel.put(KEY_COOKIES_CAP, (Object)cookies);
        templateModel.put(KEY_COOKIES, (Object)cookies);
        Authentication auth = SecurityUtils.getAuthentication((HttpServletRequest)request);
        if (auth != null) {
            templateModel.put(KEY_AUTH_CAP, (Object)auth);
            templateModel.put(KEY_AUTH, (Object)auth);
            templateModel.put(KEY_PROFILE_CAP, (Object)auth.getProfile());
            templateModel.put(KEY_PROFILE, (Object)auth.getProfile());
        }
        SiteContext siteContext = SiteContext.getCurrent();
        HierarchicalConfiguration siteConfig = siteContext.getConfig();
        Locale locale = LocaleContextHolder.getLocale();
        TemplateHashModel staticModels = BeansWrapper.getDefaultInstance().getStaticModels();
        TemplateHashModel enumModels = BeansWrapper.getDefaultInstance().getEnumModels();
        templateModel.put(KEY_STATICS_CAP, (Object)staticModels);
        templateModel.put(KEY_STATICS, (Object)staticModels);
        templateModel.put(KEY_ENUMS_CAP, (Object)enumModels);
        templateModel.put(KEY_ENUMS, (Object)enumModels);
        templateModel.put(KEY_SITE_CONTEXT_CAP, (Object)siteContext);
        templateModel.put(KEY_SITE_CONTEXT, (Object)siteContext);
        templateModel.put(KEY_LOCALE_CAP, (Object)locale);
        templateModel.put(KEY_LOCALE, (Object)locale);
        if (siteConfig != null) {
            templateModel.put(KEY_SITE_CONFIG, (Object)siteConfig);
            templateModel.put(KEY_SITE_CONFIG_CAP, (Object)siteConfig);
        }
        templateModel.putAll(model);
        1 componentModelFactory = new /* Unavailable Anonymous Inner Class!! */;
        RenderComponentDirective renderComponentDirective = new RenderComponentDirective();
        renderComponentDirective.setSiteItemService(this.siteItemService);
        renderComponentDirective.setModelFactory((ObjectFactory)componentModelFactory);
        renderComponentDirective.setTemplateXPathQuery(this.componentTemplateXPathQuery);
        renderComponentDirective.setTemplateNamePrefix(this.componentTemplateNamePrefix);
        renderComponentDirective.setTemplateNameSuffix(this.componentTemplateNameSuffix);
        renderComponentDirective.setIncludeElementName(this.componentIncludeElementName);
        renderComponentDirective.setScriptResolver(this.componentScriptResolver);
        renderComponentDirective.setServletContext(this.getServletContext());
        ExecuteControllerDirective executeControllerDirective = new ExecuteControllerDirective();
        executeControllerDirective.setServletContext(this.getServletContext());
        templateModel.put(RENDER_COMPONENT_DIRECTIVE_NAME, (Object)renderComponentDirective);
        templateModel.put(EXECUTE_CONTROLLER_DIRECTIVE_NAME, (Object)executeControllerDirective);
        return templateModel;
    }

    protected HttpSessionHashModel createSessionModel(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return new HttpSessionHashModel(session, this.getObjectWrapper());
        }
        return new HttpSessionHashModel(null, request, response, this.getObjectWrapper());
    }

    protected Map<String, String> createCookieMap(HttpServletRequest request) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isNotEmpty((Object[])cookies)) {
            for (Object cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }
}

