/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.aws.AwsProfile;
import org.craftercms.studio.api.v1.aws.AwsProfileReader;
import org.craftercms.studio.api.v1.exception.AwsConfigurationException;

public abstract class AbstractXmlProfileReader<T extends AwsProfile>
implements AwsProfileReader<T> {
    protected List<HierarchicalConfiguration> getRequiredConfigurationsAt(HierarchicalConfiguration config, String key) throws AwsConfigurationException {
        List configs = config.configurationsAt(key);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            throw new AwsConfigurationException("Missing required property '" + key + "'");
        }
        return configs;
    }

    protected String getRequiredStringProperty(Configuration config, String key) throws AwsConfigurationException {
        String property = config.getString(key);
        if (StringUtils.isEmpty((CharSequence)property)) {
            throw new AwsConfigurationException("Missing required property '" + key + "'");
        }
        return property;
    }

    protected void readBasicProperties(Configuration config, T profile) throws AwsConfigurationException {
        String accessKey = this.getRequiredStringProperty(config, "credentials.accessKey");
        String secretKey = this.getRequiredStringProperty(config, "credentials.secretKey");
        profile.setCredentials((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        profile.setRegion(this.getRequiredStringProperty(config, "region"));
    }
}

