/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.repository;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.craftercms.studio.api.v1.dal.GitLog;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.RepoOperationTO;
import org.craftercms.studio.api.v1.to.VersionTO;

public interface ContentRepository {
    public boolean contentExists(String var1, String var2);

    public InputStream getContent(String var1, String var2) throws ContentNotFoundException;

    public long getContentSize(String var1, String var2);

    public String writeContent(String var1, String var2, InputStream var3) throws ServiceException;

    public String createFolder(String var1, String var2, String var3);

    public String deleteContent(String var1, String var2, String var3);

    public Map<String, String> moveContent(String var1, String var2, String var3);

    public Map<String, String> moveContent(String var1, String var2, String var3, String var4);

    public String copyContent(String var1, String var2, String var3);

    public RepositoryItem[] getContentChildren(String var1, String var2);

    public VersionTO[] getContentVersionHistory(String var1, String var2);

    public String createVersion(String var1, String var2, boolean var3);

    public String createVersion(String var1, String var2, String var3, boolean var4);

    public String revertContent(String var1, String var2, String var3, boolean var4, String var5);

    public InputStream getContentVersion(String var1, String var2, String var3) throws ContentNotFoundException;

    public void lockItem(String var1, String var2);

    public void lockItemForPublishing(String var1, String var2);

    public void unLockItem(String var1, String var2);

    public void unLockItemForPublishing(String var1, String var2);

    public boolean createSiteFromBlueprint(String var1, String var2, String var3);

    public boolean deleteSite(String var1);

    public void initialPublish(String var1, String var2, String var3, String var4, String var5) throws DeploymentException;

    public void publish(String var1, String var2, List<DeploymentItemTO> var3, String var4, String var5, String var6) throws DeploymentException;

    public List<RepoOperationTO> getOperations(String var1, String var2, String var3);

    public String getRepoLastCommitId(String var1);

    public String getRepoFirstCommitId(String var1);

    public List<String> getEditCommitIds(String var1, String var2, String var3, String var4);

    public boolean commitIdExists(String var1, String var2);

    public GitLog getGitLog(String var1, String var2);

    public void insertGitLog(String var1, String var2, int var3);

    public void insertFullGitLog(String var1, int var2);

    public void markGitLogVerifiedProcessed(String var1, String var2);

    public void deleteGitLogForSite(String var1);

    public boolean createSiteCloneRemote(String var1, String var2, String var3, String var4, String var5, boolean var6, String var7, String var8, String var9, String var10, String var11) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, InvalidRemoteUrlException, ServiceException;

    public boolean createSitePushToRemote(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, ServiceException;

    public boolean addRemote(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws InvalidRemoteUrlException, ServiceException;

    public boolean removeRemote(String var1, String var2);

    public void removeRemoteRepositoriesForSite(String var1);

    public List<RemoteRepositoryInfoTO> listRemote(String var1, String var2) throws ServiceException;

    public boolean pushToRemote(String var1, String var2, String var3) throws ServiceException, InvalidRemoteUrlException;

    public boolean pullFromRemote(String var1, String var2, String var3) throws ServiceException, InvalidRemoteUrlException;

    public boolean isFolder(String var1, String var2);

    public void resetStagingRepository(String var1) throws ServiceException;

    public void reloadRepository(String var1);
}

