/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.to.DmDependencyTO;

public class DependencyRules {
    protected String site;
    protected ContentService contentService;
    protected ObjectStateService objectStateService;

    public DependencyRules(String site) {
        this.site = site;
    }

    public Set<DmDependencyTO> applySubmitRule(DmDependencyTO submittedItem) {
        Set dependencyTOSet;
        HashSet<DmDependencyTO> dependencies = new HashSet<DmDependencyTO>();
        if (submittedItem.getDocuments() != null) {
            for (DmDependencyTO document : submittedItem.getDocuments()) {
                if (this.objectStateService.isUpdatedOrNew(this.site, document.getUri())) {
                    document.setNow(submittedItem.isNow());
                    document.setScheduledDate(submittedItem.getScheduledDate());
                    document.setSubmitted(true);
                    dependencies.add(document);
                }
                dependencyTOSet = this.applySubmitRule(document);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getComponents() != null) {
            for (DmDependencyTO component : submittedItem.getComponents()) {
                if (this.objectStateService.isUpdatedOrNew(this.site, component.getUri())) {
                    component.setNow(submittedItem.isNow());
                    component.setScheduledDate(submittedItem.getScheduledDate());
                    component.setSubmitted(true);
                    dependencies.add(component);
                }
                dependencyTOSet = this.applySubmitRule(component);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getAssets() != null) {
            for (DmDependencyTO asset : submittedItem.getAssets()) {
                if (this.objectStateService.isUpdatedOrNew(this.site, asset.getUri())) {
                    dependencies.add(asset);
                    asset.setNow(submittedItem.isNow());
                    asset.setScheduledDate(submittedItem.getScheduledDate());
                    asset.setSubmitted(true);
                }
                dependencyTOSet = this.applySubmitRule(asset);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getRenderingTemplates() != null) {
            for (DmDependencyTO template : submittedItem.getRenderingTemplates()) {
                if (this.objectStateService.isUpdatedOrNew(this.site, template.getUri())) {
                    dependencies.add(template);
                    template.setNow(submittedItem.isNow());
                    template.setScheduledDate(submittedItem.getScheduledDate());
                    template.setSubmitted(true);
                }
                dependencyTOSet = this.applySubmitRule(template);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getLevelDescriptors() != null) {
            for (DmDependencyTO ld : submittedItem.getLevelDescriptors()) {
                if (this.objectStateService.isUpdatedOrNew(this.site, ld.getUri())) {
                    dependencies.add(ld);
                    ld.setNow(submittedItem.isNow());
                    ld.setScheduledDate(submittedItem.getScheduledDate());
                    ld.setSubmitted(true);
                }
                dependencyTOSet = this.applySubmitRule(ld);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getPages() != null) {
            for (DmDependencyTO page : submittedItem.getPages()) {
                if (this.objectStateService.isNew(this.site, page.getUri())) {
                    page.setNow(submittedItem.isNow());
                    page.setScheduledDate(submittedItem.getScheduledDate());
                    page.setSubmitted(true);
                    dependencies.add(page);
                }
                Set childPages = this.applySubmitRule(page);
                dependencies.addAll(childPages);
            }
        }
        return dependencies;
    }

    public Set<DmDependencyTO> applyDeleteDependencyRule(DmDependencyTO deletedItem) {
        return Collections.emptySet();
    }

    public Set<DmDependencyTO> applyRejectRule(DmDependencyTO submittedItem) {
        Set dependencyTOSet;
        HashSet<DmDependencyTO> dependencies = new HashSet<DmDependencyTO>();
        if (submittedItem.isSubmittedForDeletion()) {
            return this.applyDeleteDependencyRule(submittedItem);
        }
        if (submittedItem.getDocuments() != null) {
            for (DmDependencyTO document : submittedItem.getDocuments()) {
                dependencies.add(document);
                dependencyTOSet = this.applySubmitRule(document);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getComponents() != null) {
            for (DmDependencyTO component : submittedItem.getComponents()) {
                dependencies.add(component);
                dependencyTOSet = this.applySubmitRule(component);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getAssets() != null) {
            for (DmDependencyTO asset : submittedItem.getAssets()) {
                dependencies.add(asset);
                dependencyTOSet = this.applySubmitRule(asset);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getRenderingTemplates() != null) {
            for (DmDependencyTO template : submittedItem.getRenderingTemplates()) {
                dependencies.add(template);
                dependencyTOSet = this.applySubmitRule(template);
                dependencies.addAll(dependencyTOSet);
            }
        }
        if (submittedItem.getLevelDescriptors() != null) {
            for (DmDependencyTO ld : submittedItem.getLevelDescriptors()) {
                dependencies.add(ld);
                dependencyTOSet = this.applySubmitRule(ld);
                dependencies.addAll(dependencyTOSet);
            }
        }
        return dependencies;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }
}

