/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.deployment;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.studio.api.v1.dal.PublishRequest;
import org.craftercms.studio.api.v1.exception.CommitNotFoundException;
import org.craftercms.studio.api.v1.exception.EnvironmentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDeploymentTaskTO;
import org.craftercms.studio.api.v1.to.PublishStatus;
import org.craftercms.studio.api.v1.to.PublishingChannelTO;

public interface DeploymentService {
    public void deploy(String var1, String var2, List<String> var3, ZonedDateTime var4, String var5, String var6, boolean var7) throws DeploymentException;

    public void delete(String var1, List<String> var2, String var3, ZonedDateTime var4) throws DeploymentException;

    public List<PublishRequest> getScheduledItems(String var1);

    public void cancelWorkflow(String var1, String var2) throws DeploymentException;

    public void cancelWorkflowBulk(String var1, Set<String> var2) throws DeploymentException;

    public void deleteDeploymentDataForSite(String var1);

    public List<DmDeploymentTaskTO> getDeploymentHistory(String var1, int var2, int var3, String var4, boolean var5, String var6) throws SiteNotFoundException;

    public List<ContentItemTO> getScheduledItems(String var1, String var2, boolean var3, String var4, boolean var5, String var6) throws ServiceException;

    public Map<String, List<PublishingChannelTO>> getAvailablePublishingChannelGroups(String var1, String var2);

    public void syncAllContentToPreview(String var1, boolean var2) throws ServiceException;

    public void bulkGoLive(String var1, String var2, String var3) throws ServiceException;

    public ZonedDateTime getLastDeploymentDate(String var1, String var2);

    public PublishStatus getPublishStatus(String var1) throws SiteNotFoundException;

    public boolean enablePublishing(String var1, boolean var2) throws SiteNotFoundException, AuthenticationException;

    public void publishCommits(String var1, String var2, List<String> var3, String var4) throws SiteNotFoundException, EnvironmentNotFoundException, CommitNotFoundException;

    public void publishItems(String var1, String var2, ZonedDateTime var3, List<String> var4, String var5) throws ServiceException, DeploymentException;

    public void resetStagingEnvironment(String var1) throws ServiceException;
}

