/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.security;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.DeleteUserNotAllowedException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;

public interface SecurityService {
    public static final String STUDIO_SESSION_TOKEN_ATRIBUTE = "studioSessionToken";

    public String authenticate(String var1, String var2) throws BadCredentialsException, AuthenticationSystemException, EntitlementException;

    public String getCurrentUser();

    public String getCurrentToken();

    public Set<String> getUserRoles(String var1, String var2);

    public Map<String, Object> getUserProfile(String var1);

    public Set<String> getUserPermissions(String var1, String var2, String var3, List<String> var4);

    public boolean validateTicket(String var1);

    public void addUserGroup(String var1);

    public void addUserGroup(String var1, String var2);

    public void reloadConfiguration(String var1);

    public void reloadGlobalConfiguration();

    public boolean logout();

    public boolean userExists(String var1);

    public boolean createUser(String var1, String var2, String var3, String var4, String var5) throws UserAlreadyExistsException, EntitlementException;

    public boolean deleteUser(String var1) throws UserNotFoundException, DeleteUserNotAllowedException;

    public boolean updateUser(String var1, String var2, String var3, String var4) throws UserNotFoundException, UserExternallyManagedException;

    public boolean enableUser(String var1, boolean var2) throws UserNotFoundException, UserExternallyManagedException;

    public boolean createGroup(String var1, String var2, String var3) throws GroupAlreadyExistsException, SiteNotFoundException;

    public Map<String, Object> getUserStatus(String var1) throws UserNotFoundException;

    public List<Map<String, Object>> getAllUsers(int var1, int var2);

    public int getAllUsersTotal();

    public List<Map<String, Object>> getUsersPerSite(String var1, int var2, int var3) throws SiteNotFoundException;

    public int getUsersPerSiteTotal(String var1) throws SiteNotFoundException;

    public Map<String, Object> getGroup(String var1, String var2) throws GroupNotFoundException, SiteNotFoundException;

    public List<Map<String, Object>> getAllGroups(int var1, int var2);

    public List<Map<String, Object>> getGroupsPerSite(String var1, int var2, int var3) throws SiteNotFoundException;

    public int getGroupsPerSiteTotal(String var1) throws SiteNotFoundException;

    public List<Map<String, Object>> getUsersPerGroup(String var1, String var2, int var3, int var4) throws GroupNotFoundException, SiteNotFoundException;

    public int getUsersPerGroupTotal(String var1, String var2) throws GroupNotFoundException, SiteNotFoundException;

    public boolean updateGroup(String var1, String var2, String var3) throws GroupNotFoundException, SiteNotFoundException;

    public boolean deleteGroup(String var1, String var2) throws GroupNotFoundException, SiteNotFoundException;

    public boolean addUserToGroup(String var1, String var2, String var3) throws UserAlreadyExistsException, UserNotFoundException, GroupNotFoundException, SiteNotFoundException;

    public boolean removeUserFromGroup(String var1, String var2, String var3) throws UserNotFoundException, GroupNotFoundException, SiteNotFoundException;

    public Map<String, Object> forgotPassword(String var1) throws ServiceException, UserNotFoundException, UserExternallyManagedException;

    public boolean validateToken(String var1) throws UserNotFoundException, UserExternallyManagedException;

    public boolean changePassword(String var1, String var2, String var3) throws UserNotFoundException, PasswordDoesNotMatchException, UserExternallyManagedException;

    public Map<String, Object> setUserPassword(String var1, String var2) throws UserNotFoundException, UserExternallyManagedException;

    public boolean resetPassword(String var1, String var2) throws UserNotFoundException, UserExternallyManagedException;

    public boolean validateSession(HttpServletRequest var1);

    public boolean isSiteAdmin(String var1, String var2);
}

