/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.site;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.BlueprintNotFoundException;
import org.craftercms.studio.api.v1.exception.PreviewDeployerUnreachableException;
import org.craftercms.studio.api.v1.exception.SearchUnreachableException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.SiteCreationException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteConfigNotFoundException;
import org.craftercms.studio.api.v1.to.PublishStatus;
import org.craftercms.studio.api.v1.to.PublishingTargetTO;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.SiteBlueprintTO;
import org.dom4j.Document;

public interface SiteService {
    public boolean writeConfiguration(String var1, String var2, InputStream var3) throws ServiceException;

    public boolean writeConfiguration(String var1, InputStream var2) throws ServiceException;

    public Document getSiteConfiguration(String var1) throws SiteConfigNotFoundException;

    public Map<String, Object> getConfiguration(String var1);

    public Map<String, Object> getConfiguration(String var1, String var2, boolean var3);

    public List<PublishingTargetTO> getPublishingTargetsForSite(String var1);

    public Set<String> getAllAvailableSites();

    public int countSites();

    public void createSiteFromBlueprint(String var1, String var2, String var3, String var4, String var5) throws SiteAlreadyExistsException, SiteCreationException, PreviewDeployerUnreachableException, SearchUnreachableException, BlueprintNotFoundException;

    public void createSiteWithRemoteOption(String var1, String var2, String var3, String var4, String var5, String var6, String var7, boolean var8, String var9, String var10, String var11, String var12, String var13, String var14) throws ServiceException, InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, InvalidRemoteUrlException;

    public boolean deleteSite(String var1);

    public boolean syncDatabaseWithRepo(String var1, String var2);

    public SiteBlueprintTO[] getAvailableBlueprints();

    public String getPreviewServerUrl(String var1);

    public String getLiveServerUrl(String var1);

    public String getAuthoringServerUrl(String var1);

    public String getAdminEmailAddress(String var1);

    public void reloadSiteConfigurations();

    public void reloadSiteConfiguration(String var1);

    public void reloadSiteConfiguration(String var1, boolean var2);

    public void reloadGlobalConfiguration();

    public void syncRepository(String var1) throws SiteNotFoundException;

    public void rebuildDatabase(String var1);

    public void updateLastCommitId(String var1, String var2);

    public boolean exists(String var1);

    public int getSitesPerUserTotal(String var1) throws UserNotFoundException;

    public List<SiteFeed> getSitesPerUser(String var1, int var2, int var3) throws UserNotFoundException;

    public SiteFeed getSite(String var1) throws SiteNotFoundException;

    public boolean isPublishingEnabled(String var1);

    public boolean enablePublishing(String var1, boolean var2) throws SiteNotFoundException;

    public boolean updatePublishingStatusMessage(String var1, String var2) throws SiteNotFoundException;

    public PublishStatus getPublishStatus(String var1) throws SiteNotFoundException;

    public boolean addRemote(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws InvalidRemoteUrlException, ServiceException;

    public boolean removeRemote(String var1, String var2) throws SiteNotFoundException;

    public List<RemoteRepositoryInfoTO> listRemote(String var1) throws ServiceException;
}

