/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.to;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmOrderTO;
import org.craftercms.studio.api.v1.to.RenderingTemplateTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;

public class ContentItemTO
implements Serializable {
    private static final long serialVersionUID = 110010823228368718L;
    public String name;
    public String internalName;
    public String contentType;
    public String uri;
    public String path;
    public String browserUri;
    public boolean navigation;
    public boolean floating;
    public boolean hideInAuthoring;
    public boolean previewable;
    public String lockOwner;
    public String user;
    public String userFirstName;
    public String userLastName;
    public String nodeRef;
    public String metaDescription;
    public String site;
    public boolean page;
    public boolean component;
    public boolean document;
    public boolean asset;
    public boolean isContainer;
    public boolean container;
    public boolean disabled;
    public boolean savedAsDraft;
    public boolean submitted;
    public boolean submittedForDeletion;
    public boolean scheduled;
    public boolean published;
    public boolean deleted;
    public boolean inProgress;
    public boolean live;
    public boolean inFlight;
    public boolean isDisabled;
    public boolean isSavedAsDraft;
    public boolean isInProgress;
    public boolean isLive;
    public boolean isSubmittedForDeletion;
    public boolean isScheduled;
    public boolean isPublished;
    public boolean isNavigation;
    public boolean isDeleted;
    public boolean isNew;
    public boolean isSubmitted;
    public boolean isFloating;
    public boolean isPage;
    public boolean isPreviewable;
    public boolean isComponent;
    public boolean isDocument;
    public boolean isAsset;
    public boolean isInFlight;
    public ZonedDateTime eventDate;
    public String endpoint;
    public String timezone;
    public int numOfChildren;
    public ZonedDateTime scheduledDate;
    public ZonedDateTime publishedDate;
    public String mandatoryParent;
    public boolean isLevelDescriptor = false;
    public String categoryRoot;
    public ZonedDateTime lastEditDate;
    public String form;
    public String formPagePath;
    public List<RenderingTemplateTO> renderingTemplates = new ArrayList();
    public boolean folder;
    protected String submissionComment;
    protected List<ContentItemTO> components;
    protected List<ContentItemTO> documents;
    protected List<ContentItemTO> levelDescriptors;
    protected List<ContentItemTO> pages;
    protected boolean isNewFile = false;
    protected boolean isReference = false;
    protected String parentPath = null;
    protected List<DmOrderTO> orders;
    public List<ContentItemTO> children = new ArrayList();
    public double size;
    public String sizeUnit;
    public String mimeType;
    public String environment;
    public String submittedToEnvironment;
    public String packageId;

    public ContentItemTO() {
    }

    public ContentItemTO(ContentItemTO item) {
        this(item, false);
    }

    public ContentItemTO(ContentItemTO item, boolean cloneChildren) {
        this.name = item.name;
        this.internalName = item.internalName;
        this.contentType = item.contentType;
        this.uri = item.uri;
        this.path = item.path;
        this.browserUri = item.browserUri;
        this.navigation = item.navigation;
        this.floating = item.floating;
        this.hideInAuthoring = item.hideInAuthoring;
        this.previewable = item.previewable;
        this.lockOwner = item.lockOwner;
        this.user = item.user;
        this.userFirstName = item.userFirstName;
        this.userLastName = item.userLastName;
        this.nodeRef = item.nodeRef;
        this.metaDescription = item.metaDescription;
        this.site = item.site;
        this.page = item.page;
        this.component = item.component;
        this.document = item.document;
        this.asset = item.asset;
        this.isContainer = item.isContainer;
        this.container = item.container;
        this.disabled = item.disabled;
        this.savedAsDraft = item.savedAsDraft;
        this.submitted = item.submitted;
        this.submittedForDeletion = item.submittedForDeletion;
        this.scheduled = item.scheduled;
        this.published = item.published;
        this.deleted = item.deleted;
        this.inProgress = item.inProgress;
        this.live = item.live;
        this.inFlight = item.inFlight;
        this.isDisabled = item.isDisabled;
        this.isSavedAsDraft = item.isSavedAsDraft;
        this.isInProgress = item.isInProgress;
        this.isLive = item.isLive;
        this.isSubmittedForDeletion = item.isSubmittedForDeletion;
        this.isScheduled = item.isScheduled;
        this.isPublished = item.isPublished;
        this.isNavigation = item.isNavigation;
        this.isDeleted = item.isDeleted;
        this.isNew = item.isNew;
        this.isSubmitted = item.isSubmitted;
        this.isFloating = item.isFloating;
        this.isPage = item.isPage;
        this.isPreviewable = item.isPreviewable;
        this.isComponent = item.isComponent;
        this.isDocument = item.isDocument;
        this.isAsset = item.isAsset;
        this.isInFlight = item.isInFlight;
        this.eventDate = item.eventDate != null ? item.eventDate.withZoneSameInstant(ZoneOffset.UTC) : item.eventDate;
        this.endpoint = item.endpoint;
        this.timezone = item.timezone;
        this.numOfChildren = item.numOfChildren;
        this.scheduledDate = item.scheduledDate != null ? item.scheduledDate.withZoneSameInstant(ZoneOffset.UTC) : item.scheduledDate;
        this.publishedDate = item.publishedDate != null ? item.publishedDate.withZoneSameInstant(ZoneOffset.UTC) : item.publishedDate;
        this.mandatoryParent = item.mandatoryParent;
        this.isLevelDescriptor = item.isLevelDescriptor;
        this.categoryRoot = item.categoryRoot;
        this.lastEditDate = item.lastEditDate != null ? item.lastEditDate.withZoneSameInstant(ZoneOffset.UTC) : item.lastEditDate;
        this.form = item.form;
        this.formPagePath = item.formPagePath;
        this.renderingTemplates = item.renderingTemplates;
        this.folder = item.folder;
        this.submissionComment = item.submissionComment;
        this.components = item.components;
        this.documents = item.documents;
        this.levelDescriptors = item.levelDescriptors;
        this.pages = item.pages;
        this.isNewFile = item.isNewFile;
        this.isReference = item.isReference;
        this.parentPath = item.parentPath;
        this.orders = item.orders;
        this.mimeType = item.mimeType;
        this.environment = item.environment;
        this.submittedToEnvironment = item.submittedToEnvironment;
        this.packageId = item.packageId;
        if (cloneChildren && item.children != null) {
            this.children = new ArrayList(item.children.size());
            for (ContentItemTO child : item.children) {
                this.children.add(new ContentItemTO(child));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getBrowserUri() {
        return this.browserUri;
    }

    public void setBrowserUri(String browserUri) {
        this.browserUri = browserUri;
    }

    public boolean isNavigation() {
        return this.navigation;
    }

    public void setNavigation(boolean navigation) {
        this.navigation = navigation;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean floating) {
        this.floating = floating;
    }

    public boolean isHideInAuthoring() {
        return this.hideInAuthoring;
    }

    public void setHideInAuthoring(boolean hideInAuthoring) {
        this.hideInAuthoring = hideInAuthoring;
    }

    public boolean isPreviewable() {
        return this.previewable;
    }

    public void setPreviewable(boolean previewable) {
        this.previewable = previewable;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public String getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(String nodeRef) {
        this.nodeRef = nodeRef;
    }

    public String getMetaDescription() {
        return this.metaDescription;
    }

    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    public boolean isPage() {
        return this.page;
    }

    public void setPage(boolean page) {
        this.page = page;
    }

    public boolean isComponent() {
        return this.component;
    }

    public void setComponent(boolean component) {
        this.component = component;
    }

    public boolean isDocument() {
        return this.document;
    }

    public void setDocument(boolean document) {
        this.document = document;
    }

    public boolean isAsset() {
        return this.asset;
    }

    public void setAsset(boolean asset) {
        this.asset = asset;
    }

    public ZonedDateTime getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(ZonedDateTime eventDate) {
        this.eventDate = eventDate != null ? eventDate.withZoneSameInstant(ZoneOffset.UTC) : eventDate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public int getNumOfChildren() {
        return this.numOfChildren;
    }

    public void setNumOfChildren(int numOfChildren) {
        this.numOfChildren = numOfChildren;
    }

    public ZonedDateTime getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(ZonedDateTime scheduledDate) {
        this.scheduledDate = scheduledDate != null ? scheduledDate.withZoneSameInstant(ZoneOffset.UTC) : scheduledDate;
    }

    public ZonedDateTime getPublishedDate() {
        return this.publishedDate;
    }

    public void setPublishedDate(ZonedDateTime publishedDate) {
        this.publishedDate = publishedDate != null ? publishedDate.withZoneSameInstant(ZoneOffset.UTC) : publishedDate;
    }

    public String getMandatoryParent() {
        return this.mandatoryParent;
    }

    public void setMandatoryParent(String mandatoryParent) {
        this.mandatoryParent = mandatoryParent;
    }

    public boolean isLevelDescriptor() {
        return this.isLevelDescriptor;
    }

    public void setLevelDescriptor(boolean isLevelDescriptor) {
        this.isLevelDescriptor = isLevelDescriptor;
    }

    public List<ContentItemTO> getChildren() {
        return this.children;
    }

    public void setChildren(List<ContentItemTO> children) {
        this.children = children;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isSubmittedForDeletion() {
        return this.submittedForDeletion;
    }

    public void setSubmittedForDeletion(boolean submittedForDeletion) {
        this.submittedForDeletion = submittedForDeletion;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public String getCategoryRoot() {
        return this.categoryRoot;
    }

    public void setCategoryRoot(String categoryRoot) {
        this.categoryRoot = categoryRoot;
    }

    public ZonedDateTime getLastEditDate() {
        return this.lastEditDate;
    }

    public void setLastEditDate(ZonedDateTime lastEditDate) {
        this.lastEditDate = lastEditDate != null ? lastEditDate.withZoneSameInstant(ZoneOffset.UTC) : lastEditDate;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getFormPagePath() {
        return this.formPagePath;
    }

    public void setFormPagePath(String formPagePath) {
        this.formPagePath = formPagePath;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public String getSubmissionComment() {
        return this.submissionComment;
    }

    public void setSubmissionComment(String submissionComment) {
        this.submissionComment = submissionComment;
    }

    public List<ContentItemTO> getComponents() {
        return this.components;
    }

    public void setComponents(List<ContentItemTO> components) {
        this.components = components;
    }

    public List<ContentItemTO> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<ContentItemTO> documents) {
        this.documents = documents;
    }

    public List<ContentItemTO> getLevelDescriptors() {
        return this.levelDescriptors;
    }

    public void setLevelDescriptors(List<ContentItemTO> levelDescriptors) {
        this.levelDescriptors = levelDescriptors;
    }

    public boolean isNewFile() {
        return this.isNewFile;
    }

    public void setNewFile(boolean isNewFile) {
        this.isNewFile = isNewFile;
    }

    public List<ContentItemTO> getPages() {
        return this.pages;
    }

    public void setPages(List<ContentItemTO> pages) {
        this.pages = pages;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public List<DmOrderTO> getOrders() {
        return this.orders;
    }

    public void setOrders(List<DmOrderTO> orders) {
        this.orders = orders;
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    public void setInFlight(boolean inFlight) {
        this.inFlight = inFlight;
    }

    public Double getOrder(String orderName) {
        if (orderName != null && this.orders != null) {
            for (DmOrderTO order : this.orders) {
                if (!orderName.equalsIgnoreCase(order.getId())) continue;
                return order.getOrder();
            }
        }
        return -1.0;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public String getSizeUnit() {
        return this.sizeUnit;
    }

    public void setSizeUnit(String sizeUnit) {
        this.sizeUnit = sizeUnit;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getSubmittedToEnvironment() {
        return this.submittedToEnvironment;
    }

    public void setSubmittedToEnvironment(String submittedToEnvironment) {
        this.submittedToEnvironment = submittedToEnvironment;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public void addChild(ContentItemTO itemToAdd, boolean recursive, boolean renamed) {
        if (this.uri != null && this.uri.equals(itemToAdd.uri)) {
            return;
        }
        if (recursive && (this.isNew || this.isDeleted || renamed) && !this.submittedForDeletion) {
            itemToAdd.mandatoryParent = this.uri;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(itemToAdd);
        ++this.numOfChildren;
    }

    public void addChild(ContentItemTO itemToAdd, DmContentItemComparator comparator, boolean recursive) {
        this.addChild(itemToAdd, comparator, recursive, false);
    }

    public void addChild(ContentItemTO itemToAdd, DmContentItemComparator comparator, boolean recursive, boolean renamed) {
        if (this.uri != null && this.uri.equals(itemToAdd.uri)) {
            return;
        }
        if (recursive && (this.isNew || this.isDeleted || renamed) && !this.submittedForDeletion && !itemToAdd.isSubmittedForDeletion) {
            itemToAdd.mandatoryParent = this.uri;
        }
        if (this.children != null) {
            if (this.children.contains(itemToAdd)) {
                return;
            }
            boolean added = false;
            int pos = 0;
            ArrayList<Integer> childPositions = new ArrayList<Integer>(this.children.size());
            for (int index = 0; index < this.children.size(); ++index) {
                int compareResult;
                String itemToAddUri;
                ContentItemTO child = (ContentItemTO)this.children.get(index);
                String childUri = StringUtils.isEmpty((CharSequence)child.browserUri) ? child.uri : child.browserUri;
                String string = itemToAddUri = StringUtils.isEmpty((CharSequence)itemToAdd.browserUri) ? itemToAdd.uri : itemToAdd.browserUri;
                if (recursive) {
                    compareResult = comparator.compare(child, itemToAdd);
                    if (compareResult < 0) {
                        pos = index + 1 + 0;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)itemToAddUri)) continue;
                    if (itemToAddUri.startsWith(childUri + "/")) {
                        child.addChild(itemToAdd, comparator, recursive);
                        added = true;
                        break;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)childUri) || !childUri.startsWith(itemToAddUri + "/")) continue;
                    if (childPositions.size() == 0) {
                        itemToAdd.addChild(child, comparator, recursive);
                        this.children.set(index, itemToAdd);
                        added = true;
                    }
                    childPositions.add(index);
                    continue;
                }
                compareResult = comparator.compare(itemToAdd, child);
                if (compareResult < 0) {
                    this.children.add(index, itemToAdd);
                    added = true;
                    break;
                }
                pos = index + 1;
            }
            if (!added) {
                this.children.add(pos, itemToAdd);
            }
            if (recursive && childPositions.size() > 1) {
                for (int childIndex = 1; childIndex < childPositions.size(); ++childIndex) {
                    int targetPosition = (Integer)childPositions.get(childIndex);
                    if (childIndex > 1) {
                        targetPosition -= childIndex - 1;
                    }
                    itemToAdd.addChild((ContentItemTO)this.children.get(targetPosition), comparator, recursive);
                    this.children.remove(targetPosition);
                }
            }
        } else {
            this.children = new ArrayList();
            this.children.add(itemToAdd);
        }
        ++this.numOfChildren;
    }

    public void addChild(ContentItemTO itemToAdd, DmContentItemComparator comparator, boolean recursive, ChildFilter childFilter) {
        if (this.uri != null && this.uri.equals(itemToAdd.getUri())) {
            return;
        }
        if (recursive && (this.isNew || this.isDeleted)) {
            itemToAdd.setMandatoryParent(this.uri);
        }
        if (this.children != null) {
            if (this.children.contains(itemToAdd)) {
                return;
            }
            boolean added = false;
            int pos = 0;
            ArrayList<Integer> childPositions = new ArrayList<Integer>(this.children.size());
            for (int index = 0; index < this.children.size(); ++index) {
                String itemToAddUri;
                ContentItemTO child = (ContentItemTO)this.children.get(index);
                String childUri = child.getBrowserUri();
                if (StringUtils.isEmpty((CharSequence)childUri)) {
                    childUri = child.getUri();
                }
                if (StringUtils.isEmpty((CharSequence)(itemToAddUri = itemToAdd.getBrowserUri()))) {
                    itemToAddUri = itemToAdd.getUri();
                }
                if (recursive) {
                    if (comparator.compare(child, itemToAdd) < 0) {
                        pos = index + 1 + 0;
                    }
                    if (itemToAddUri.startsWith(childUri + "/")) {
                        child.addChild(itemToAdd, comparator, recursive);
                        added = true;
                        break;
                    }
                    if (!childUri.startsWith(itemToAddUri + "/")) continue;
                    if (childPositions.size() == 0) {
                        itemToAdd.addChild(child, comparator, recursive);
                        if (childFilter.accept(itemToAdd)) {
                            this.children.set(index, itemToAdd);
                        }
                        added = true;
                    }
                    childPositions.add(index);
                    continue;
                }
                if (comparator.compare(itemToAdd, child) < 0) {
                    if (!childFilter.accept(itemToAdd)) break;
                    this.children.add(index, itemToAdd);
                    added = true;
                    break;
                }
                pos = index + 1;
            }
            if (!added && childFilter.accept(itemToAdd)) {
                this.children.add(pos, itemToAdd);
            }
            if (recursive && childPositions.size() > 1) {
                for (int childIndex = 1; childIndex < childPositions.size(); ++childIndex) {
                    int targetPosition = (Integer)childPositions.get(childIndex);
                    if (childIndex > 1) {
                        targetPosition -= childIndex - 1;
                    }
                    itemToAdd.addChild((ContentItemTO)this.children.get(targetPosition), comparator, recursive);
                    this.children.remove(targetPosition);
                }
            }
        } else {
            this.children = new ArrayList();
            if (childFilter.accept(itemToAdd)) {
                this.children.add(itemToAdd);
            }
        }
        ++this.numOfChildren;
    }
}

