/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.to;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class EmailMessageTO
implements Serializable {
    private static final long serialVersionUID = -509714280274105998L;
    protected String subject;
    protected String content;
    protected String to;
    protected String personalFromName;
    protected String replyTo;
    protected String previewBaseUrl;
    protected String liveBaseUrl;
    protected String authoringBaseUrl;
    protected String browserUrl;
    protected String adminEmail;
    protected String rejectReason;
    protected String title;
    protected Map<String, String> keyValueMap;
    protected String[] emailTemplateKeywords = new String[]{"title", "preview-url", "live-url", "authoring-url", "user-name", "admin-email", "reject-reason"};
    public static final String EMAIL_TEMPLATE_KEYWORDS_ADMINEMAIL = "admin-email";
    public static final String EMAIL_TEMPLATE_KEYWORDS_USERNAME = "user-name";
    public static final String EMAIL_TEMPLATE_KEYWORDS_PREVIEWURL = "preview-url";
    public static final String EMAIL_TEMPLATE_KEYWORDS_LIVEURL = "live-url";
    public static final String EMAIL_TEMPLATE_KEYWORDS_AUTHORINGURL = "authoring-url";
    public static final String EMAIL_TEMPLATE_KEYWORDS_TITLE = "title";
    public static final String EMAIL_TEMPLATE_REJECT_REASON = "reject-reason";

    public String getBrowserUrl() {
        return this.browserUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (title != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_TITLE, title);
        }
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
        if (adminEmail != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_ADMINEMAIL, adminEmail);
        }
    }

    public void setBrowserUrl(String browserUrl) {
        this.browserUrl = browserUrl;
        String previewUrl = this.previewBaseUrl + browserUrl;
        String liveUrl = this.liveBaseUrl + browserUrl;
        if (previewUrl != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_PREVIEWURL, previewUrl);
        }
        if (liveUrl != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_LIVEURL, liveUrl);
        }
    }

    public void setBrowserUrlForExternalDocument(String browserUrl) {
        this.browserUrl = browserUrl;
        if (browserUrl != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_PREVIEWURL, browserUrl);
        }
        if (browserUrl != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_LIVEURL, browserUrl);
        }
    }

    protected String getRelativeUrl(String fullUrl) {
        String relativeUrl = "";
        return relativeUrl;
    }

    public String getPreviewBaseUrl() {
        return this.previewBaseUrl;
    }

    public void setPreviewBaseUrl(String previewBaseUrl) {
        this.previewBaseUrl = previewBaseUrl;
    }

    public String getLiveBaseUrl() {
        return this.liveBaseUrl;
    }

    public void setLiveBaseUrl(String liveBaseUrl) {
        this.liveBaseUrl = liveBaseUrl;
    }

    public String getAuthoringBaseUrl() {
        return this.authoringBaseUrl;
    }

    public void setAuthoringBaseUrl(String authoringBaseUrl) {
        this.authoringBaseUrl = authoringBaseUrl;
        if (StringUtils.isNotEmpty((CharSequence)authoringBaseUrl)) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_AUTHORINGURL, authoringBaseUrl);
        }
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
        if (rejectReason != null) {
            this.setValue(EMAIL_TEMPLATE_REJECT_REASON, rejectReason);
        }
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public String getValue(String key) {
        return (String)this.keyValueMap.get(key);
    }

    public void setValue(String key, String value) {
        this.keyValueMap.put(key, value);
    }

    public String getPersonalFromName() {
        return this.personalFromName;
    }

    public void setPersonalFromName(String personalFromName) {
        this.personalFromName = personalFromName;
        if (personalFromName != null) {
            this.setValue(EMAIL_TEMPLATE_KEYWORDS_USERNAME, personalFromName);
        }
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public EmailMessageTO(String subject, String content, String to) {
        this.subject = subject;
        this.content = content;
        this.to = to;
        this.keyValueMap = new TreeMap();
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void preprocessEmail() {
        String newContent;
        String newSubject;
        this.subject = newSubject = this.replaceKeywordsByValue(this.subject);
        this.content = newContent = this.replaceKeywordsByValue(this.content);
    }

    protected String replaceKeywordsByValue(String input) {
        String output = input;
        for (int counter = 0; counter < this.emailTemplateKeywords.length; ++counter) {
            String keyword = this.emailTemplateKeywords[counter];
            String value = this.getValue(keyword);
            if (value == null) continue;
            output = output.replace("$" + keyword, value);
        }
        return output;
    }
}

