/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.to;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;

public class GoLiveDeleteCandidates
implements Serializable {
    private static final long serialVersionUID = -8844670158916016139L;
    protected Set<String> paths = new HashSet();
    protected Set<String> dependencies = new HashSet();
    protected Set<String> liveDependencyItems = new HashSet();
    protected ContentService contentService;
    protected String site;
    protected ObjectStateService objectStateService;

    public GoLiveDeleteCandidates(String site, ContentService contentService, ObjectStateService objectStateService) {
        this.contentService = contentService;
        this.objectStateService = objectStateService;
        this.site = site;
    }

    public Set<String> getAllItems() {
        HashSet<String> all = new HashSet<String>();
        if (!this.paths.isEmpty()) {
            all.addAll(this.paths);
        }
        if (!this.dependencies.isEmpty()) {
            all.addAll(this.dependencies);
        }
        return all;
    }

    public boolean addDependency(String uri) {
        if (this.contentService.contentExists(this.site, uri)) {
            if (!this.objectStateService.isNew(this.site, uri)) {
                this.liveDependencyItems.add(uri);
            }
            this.dependencies.add(uri);
            return true;
        }
        return false;
    }

    public void addDependencyParentFolder(String uri) {
        if (this.contentService.contentExists(this.site, uri)) {
            if (!this.objectStateService.isNew(this.site, uri)) {
                Iterator iterator = this.liveDependencyItems.iterator();
                while (iterator.hasNext()) {
                    String liveItem = (String)iterator.next();
                    if (!liveItem.startsWith(uri)) continue;
                    iterator.remove();
                }
                this.liveDependencyItems.add(uri);
            }
            this.dependencies.add(uri);
        }
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    public Set<String> getLiveDependencyItems() {
        return this.liveDependencyItems;
    }

    public void setLiveDependencyItems(Set<String> liveItems) {
        this.liveDependencyItems = liveItems;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<String> dependencies) {
        this.dependencies = dependencies;
    }
}

