/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.asset.processing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.studio.api.v1.asset.Asset;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessor;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessorPipeline;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessorResolver;
import org.craftercms.studio.api.v1.asset.processing.ProcessorConfiguration;
import org.craftercms.studio.api.v1.asset.processing.ProcessorPipelineConfiguration;
import org.craftercms.studio.api.v1.exception.AssetProcessingException;

public class AssetProcessorPipelineImpl
implements AssetProcessorPipeline {
    private AssetProcessorResolver processorFactory;

    public AssetProcessorPipelineImpl(AssetProcessorResolver processorFactory) {
        this.processorFactory = processorFactory;
    }

    public List<Asset> processAsset(ProcessorPipelineConfiguration config, Asset input) throws AssetProcessingException {
        Matcher inputPatMatcher = this.matchForProcessing(config, input);
        if (inputPatMatcher != null) {
            LinkedHashSet<Asset> outputs = new LinkedHashSet<Asset>();
            Asset originalInput = input;
            Map processors = this.getProcessors(config);
            if (config.isKeepOriginal()) {
                outputs.add(originalInput);
            }
            for (Map.Entry entry : processors.entrySet()) {
                Asset output = ((AssetProcessor)entry.getValue()).processAsset((ProcessorConfiguration)entry.getKey(), inputPatMatcher, input);
                outputs.add(output);
                input = output;
            }
            if (!config.isKeepOriginal() && outputs.contains(originalInput)) {
                outputs.remove(originalInput);
            }
            return new ArrayList<Asset>(outputs);
        }
        return Collections.emptyList();
    }

    private Matcher matchForProcessing(ProcessorPipelineConfiguration config, Asset input) {
        Pattern inputPathPattern = Pattern.compile(config.getInputPathPattern());
        Matcher inputPathMatcher = inputPathPattern.matcher(input.getRepoPath());
        if (inputPathMatcher.matches()) {
            return inputPathMatcher;
        }
        return null;
    }

    private Map<ProcessorConfiguration, AssetProcessor> getProcessors(ProcessorPipelineConfiguration config) throws AssetProcessingException {
        LinkedHashMap<ProcessorConfiguration, AssetProcessor> processors = new LinkedHashMap<ProcessorConfiguration, AssetProcessor>(config.getProcessorsConfig().size());
        for (ProcessorConfiguration processorConfig : config.getProcessorsConfig()) {
            processors.put(processorConfig, this.processorFactory.getProcessor(processorConfig));
        }
        return processors;
    }
}

