/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.aws.elastictranscoder;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoder;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderClientBuilder;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.aws.elastictranscoder.ElasticTranscoder;
import org.craftercms.studio.api.v1.aws.elastictranscoder.TranscoderJob;
import org.craftercms.studio.api.v1.aws.elastictranscoder.TranscoderOutput;
import org.craftercms.studio.api.v1.aws.elastictranscoder.TranscoderProfile;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.craftercms.studio.impl.v1.service.aws.AwsUtils;

public class ElasticTranscoderImpl
implements ElasticTranscoder {
    protected int partSize = 0x500000;

    public void setPartSize(int partSize) {
        this.partSize = partSize;
    }

    public TranscoderJob startJob(String filename, InputStream content, TranscoderProfile profile) throws AwsException {
        try {
            AmazonS3 s3Client = this.getS3Client(profile);
            AmazonElasticTranscoder transcoderClient = this.getTranscoderClient(profile);
            Pipeline pipeline = this.getPipeline(profile.getPipelineId(), transcoderClient);
            String baseKey = FilenameUtils.removeExtension((String)filename) + "/" + UUID.randomUUID().toString();
            String inputKey = baseKey + "." + FilenameUtils.getExtension((String)filename);
            this.uploadInput(inputKey, filename, content, pipeline, s3Client);
            CreateJobResult jobResult = this.createJob(inputKey, baseKey, profile, transcoderClient);
            return this.createResult(baseKey, jobResult, pipeline);
        }
        catch (Exception e) {
            throw new AwsException("Error while attempting to start an AWS Elastic Transcoder job for file " + filename, e);
        }
    }

    protected Pipeline getPipeline(String pipelineId, AmazonElasticTranscoder client) {
        ReadPipelineRequest readPipelineRequest = new ReadPipelineRequest();
        readPipelineRequest.setId(pipelineId);
        ReadPipelineResult result = client.readPipeline(readPipelineRequest);
        return result.getPipeline();
    }

    protected void uploadInput(String inputKey, String filename, InputStream content, Pipeline pipeline, AmazonS3 s3Client) throws AwsException {
        String inputBucket = pipeline.getInputBucket();
        AwsUtils.uploadStream((String)inputBucket, (String)inputKey, (AmazonS3)s3Client, (int)this.partSize, (String)filename, (InputStream)content);
    }

    protected CreateJobResult createJob(String inputKey, String baseKey, TranscoderProfile profile, AmazonElasticTranscoder transcoderClient) {
        CreateJobRequest jobRequest = this.getCreateJobRequest(inputKey, baseKey, profile);
        CreateJobResult jobResult = transcoderClient.createJob(jobRequest);
        return jobResult;
    }

    protected TranscoderJob createResult(String baseKey, CreateJobResult jobResult, Pipeline pipeline) {
        TranscoderJob job = new TranscoderJob();
        job.setId(jobResult.getJob().getId());
        job.setOutputBucket(pipeline.getOutputBucket());
        job.setBaseKey(baseKey);
        return job;
    }

    protected AmazonS3 getS3Client(TranscoderProfile profile) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(profile.getCredentials()))).withRegion(profile.getRegion())).build();
    }

    protected AmazonElasticTranscoder getTranscoderClient(TranscoderProfile profile) {
        return (AmazonElasticTranscoder)((AmazonElasticTranscoderClientBuilder)((AmazonElasticTranscoderClientBuilder)AmazonElasticTranscoderClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(profile.getCredentials()))).withRegion(profile.getRegion())).build();
    }

    protected CreateJobRequest getCreateJobRequest(String inputKey, String baseKey, TranscoderProfile profile) {
        JobInput jobInput = new JobInput();
        jobInput.setKey(inputKey);
        ArrayList<CreateJobOutput> jobOutputs = new ArrayList<CreateJobOutput>(profile.getOutputs().size());
        for (TranscoderOutput output : profile.getOutputs()) {
            jobOutputs.add(this.getCreateJobOutput(baseKey, output));
        }
        CreateJobRequest jobRequest = new CreateJobRequest();
        jobRequest.setPipelineId(profile.getPipelineId());
        jobRequest.setInput(jobInput);
        jobRequest.setOutputs(jobOutputs);
        return jobRequest;
    }

    protected CreateJobOutput getCreateJobOutput(String baseKey, TranscoderOutput output) {
        CreateJobOutput jobOutput = new CreateJobOutput();
        jobOutput.setPresetId(output.getPresetId());
        jobOutput.setKey(baseKey + output.getOutputKeySuffix());
        if (StringUtils.isNotEmpty((CharSequence)output.getThumbnailSuffixFormat())) {
            jobOutput.setThumbnailPattern(baseKey + output.getThumbnailSuffixFormat());
        }
        return jobOutput;
    }
}

