/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.InputStream;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.content.pipeline.FormDmContentProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class AssetDmContentProcessor
extends FormDmContentProcessor {
    public static final String FILE_SIZE_MB = "MB";
    public static final String FILE_SIZE_KB = "KB";
    private static final Logger logger = LoggerFactory.getLogger(AssetDmContentProcessor.class);
    public static final String NAME = "WriteAssetToDmProcessor";
    protected ObjectStateService objectStateService;
    protected StudioConfiguration studioConfiguration;

    public String getAssetsSystemPath() {
        return this.studioConfiguration.getProperty("studio.contentProcessor.assetsSystemPath");
    }

    public AssetDmContentProcessor() {
        super(NAME);
    }

    public AssetDmContentProcessor(String name) {
        super(name);
    }

    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String site = content.getProperty("site");
        String user = content.getProperty("user");
        String path = content.getProperty("path");
        String fileName = content.getProperty("fileName");
        String widthStr = content.getProperty("width");
        String heightStr = content.getProperty("height");
        int width = widthStr != null ? Integer.parseInt(widthStr) : -1;
        int height = heightStr != null ? Integer.parseInt(heightStr) : -1;
        String unlockValue = content.getProperty("unlock");
        boolean unlock = StringUtils.isEmpty((CharSequence)unlockValue) || !unlockValue.equalsIgnoreCase("false");
        boolean isPreview = ContentFormatUtils.getBooleanValue((String)content.getProperty("isPreview"));
        boolean isSystemAsset = ContentFormatUtils.getBooleanValue((String)content.getProperty("systemAsset"));
        boolean createFolders = ContentFormatUtils.getBooleanValue((String)content.getProperty("createFolders"));
        try {
            ContentAssetInfoTO oldAssetInfo = (ContentAssetInfoTO)result.getItem();
            ContentAssetInfoTO assetInfo = this.writeContentAsset(content, site, user, path, fileName, content.getContentStream(), width, height, createFolders, isPreview, unlock, isSystemAsset, result);
            if (oldAssetInfo != null) {
                oldAssetInfo.setFileExtension(assetInfo.getFileExtension());
                oldAssetInfo.setFileName(assetInfo.getFileName());
                oldAssetInfo.setSize(assetInfo.getSize());
                oldAssetInfo.setSizeUnit(assetInfo.getSizeUnit());
                result.setItem((Serializable)oldAssetInfo);
            } else {
                result.setItem((Serializable)assetInfo);
            }
        }
        catch (ServiceException e) {
            throw new ContentProcessException("Failed to write " + content.getId() + ", " + (Object)((Object)e), (Exception)((Object)e));
        }
        finally {
            content.closeContentStream();
        }
    }

    protected ContentAssetInfoTO writeContentAsset(PipelineContent content, String site, String user, String path, String assetName, InputStream in, int width, int height, boolean createFolders, boolean isPreview, boolean unlock, boolean isSystemAsset, ResultTO result) throws ServiceException {
        logger.debug("Writing content asset: [site: " + site + ", path: " + path + ", assetName: " + assetName + ", createFolders: " + createFolders, new Object[0]);
        String ext = null;
        int index = assetName.lastIndexOf(".");
        if (index > 0 && index + 1 < assetName.length()) {
            ext = assetName.substring(index + 1).toUpperCase();
        }
        String contentPath = path + "/" + assetName;
        try {
            ContentItemTO parentContentItem = this.contentService.getContentItem(site, path, 0);
            boolean parentExists = this.contentService.contentExists(site, path);
            if (!parentExists && createFolders) {
                parentContentItem = this.createMissingFoldersInPath(site, path, isPreview);
                parentExists = this.contentService.contentExists(site, path);
            }
            if (parentExists && parentContentItem.isFolder()) {
                boolean exists = this.contentService.contentExists(site, path + "/" + assetName);
                ContentItemTO contentItem = null;
                if (exists) {
                    contentItem = this.contentService.getContentItem(site, path + "/" + assetName, 0);
                    this.updateFile(site, contentItem, contentPath, in, user, isPreview, unlock, result);
                    content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                } else {
                    contentItem = this.createNewFile(site, parentContentItem, assetName, null, in, user, unlock, result);
                    content.addProperty("activityType", ActivityService.ActivityType.CREATED.toString());
                    this.objectStateService.insertNewEntry(site, contentItem);
                }
                ContentAssetInfoTO assetInfo = new ContentAssetInfoTO();
                assetInfo.setFileName(assetName);
                long sizeInBytes = this.contentService.getContentSize(site, path + "/" + assetName);
                double convertedSize = 0.0;
                if (sizeInBytes > 0L) {
                    convertedSize = (double)sizeInBytes / 1024.0;
                    if (convertedSize >= 1024.0) {
                        assetInfo.setSizeUnit(FILE_SIZE_MB);
                        assetInfo.setSize(convertedSize / 1024.0);
                    } else {
                        if (convertedSize > 0.0 && convertedSize < 1.0) {
                            assetInfo.setSize(1.0);
                        } else {
                            assetInfo.setSize((double)Math.round(convertedSize));
                        }
                        assetInfo.setSizeUnit(FILE_SIZE_KB);
                    }
                }
                assetInfo.setFileExtension(ext);
                ContentAssetInfoTO contentAssetInfoTO = assetInfo;
                return contentAssetInfoTO;
            }
            throw new ServiceException(path + " does not exist or not a directory.");
        }
        finally {
            ContentUtils.release((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFile(String site, ContentItemTO contentItem, String relativePath, InputStream input, String user, boolean isPreview, boolean unlock, ResultTO result) throws ServiceException {
        boolean success = false;
        try {
            success = this.contentService.writeContent(site, relativePath, input);
        }
        finally {
            ContentUtils.release((InputStream)input);
        }
        if (success) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("modifier", user);
            properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
            if (unlock) {
                properties.put("lockOwner", "");
            } else {
                properties.put("lockOwner", user);
            }
            if (!this.objectMetadataManager.metadataExist(site, relativePath)) {
                this.objectMetadataManager.insertNewObjectMetadata(site, relativePath);
            }
            this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
            result.setCommitId(this.objectMetadataManager.getProperties(site, relativePath).getCommitId());
            if (!isPreview) {
                if (this.cancelWorkflow(site, relativePath)) {
                    this.workflowService.removeFromWorkflow(site, relativePath, true);
                } else if (this.updateWorkFlow(site, relativePath)) {
                    this.workflowService.updateWorkflowSandboxes(site, relativePath);
                }
            }
        }
        if (unlock) {
            this.contentService.unLockContent(site, relativePath);
            logger.debug("Unlocked the content site " + site + " path " + relativePath, new Object[0]);
        } else {
            this.contentService.lockContent(site, relativePath);
        }
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

