/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentNotAllowedException;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class CheckImageSizeProcessor
extends PathMatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CheckImageSizeProcessor.class);
    public static final String NAME = "CheckImageSizeProcessor";

    public CheckImageSizeProcessor() {
        super(NAME);
    }

    public CheckImageSizeProcessor(String name) {
        super(name);
    }

    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        boolean process;
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String name = content.getProperty("fileName");
        String mimetype = mimeTypesMap.getContentType(name);
        boolean bl = StringUtils.isEmpty((CharSequence)mimetype) ? false : (process = mimetype.startsWith("image/") && !StringUtils.equalsIgnoreCase((CharSequence)mimetype, (CharSequence)"image/svg+xml"));
        if (process) {
            String allowLessSize = content.getProperty("allowLessSize");
            boolean lessSize = ContentFormatUtils.getBooleanValue((String)allowLessSize);
            String allowedWidth = content.getProperty("allowedWidth");
            String allowedHeight = content.getProperty("allowedHeight");
            int width = StringUtils.isEmpty((CharSequence)allowedWidth) ? -1 : ContentFormatUtils.getIntValue((String)allowedWidth);
            int height = StringUtils.isEmpty((CharSequence)allowedHeight) ? -1 : ContentFormatUtils.getIntValue((String)allowedHeight);
            InputStream in = content.getContentStream();
            ContentAssetInfoTO assetInfo = result.getItem() == null ? new ContentAssetInfoTO() : (ContentAssetInfoTO)result.getItem();
            in = this.checkForImageSize(in, width, height, lessSize, assetInfo);
            content.getProperties().put("width", String.valueOf(assetInfo.getWidth()));
            content.getProperties().put("height", String.valueOf(assetInfo.getHeight()));
            assetInfo.getWidth();
            result.setItem((Serializable)assetInfo);
            content.setContentStream(in);
        }
    }

    protected InputStream checkForImageSize(InputStream in, int allowedWidth, int allowedHeight, boolean lessSize, ContentAssetInfoTO assetInfo) throws ContentProcessException {
        ByteArrayOutputStream byteOutput = null;
        try {
            byteOutput = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = in.read(buffer)) > 0) {
                byteOutput.write(buffer, 0, read);
            }
            byte[] imageData = byteOutput.toByteArray();
            Image image = Toolkit.getDefaultToolkit().createImage(imageData);
            ImageIcon icon = new ImageIcon(image);
            int height = icon.getIconHeight();
            int width = icon.getIconWidth();
            if (allowedHeight > 0 && allowedWidth > 0) {
                this.validateImageSize(allowedWidth, allowedHeight, height, width, lessSize);
            }
            assetInfo.setHeight(height);
            assetInfo.setWidth(width);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageData);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new ContentProcessException((Exception)e);
        }
        finally {
            ContentUtils.release((InputStream)in);
            ContentUtils.release((OutputStream)byteOutput);
        }
    }

    protected void validateImageSize(int allowedWidth, int allowedHeight, int height, int width, boolean lessSize) throws ContentNotAllowedException {
        if (height < 0 || width < 0) {
            throw new ContentNotAllowedException("An image must be provided.");
        }
        boolean success = true;
        if (!lessSize) {
            if (allowedWidth > 0 && allowedWidth != width) {
                success = false;
            }
            if (allowedHeight > 0 && allowedHeight != height) {
                success = false;
            }
            if (!success) {
                throw new ContentNotAllowedException("The width and the height of the image must match to the specified width and height: " + allowedWidth + "X" + allowedHeight + ". The actual width and height: " + width + "X" + height);
            }
        } else {
            if (allowedWidth > 0 && allowedWidth < width) {
                success = false;
            }
            if (allowedHeight > 0 && allowedHeight < height) {
                success = false;
            }
            if (!success) {
                throw new ContentNotAllowedException("The width and the height of the image must be less then or equal to the specified width and height: " + allowedWidth + "X" + allowedHeight + ". The actual width and height: " + width + "X" + height);
            }
        }
    }
}

