/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.util.List;
import org.craftercms.studio.api.v1.content.pipeline.ContentProcessor;
import org.craftercms.studio.api.v1.content.pipeline.ContentProcessorPipeline;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.ResultTO;

public class ContentProcessorPipelineImpl
implements ContentProcessorPipeline {
    private static final Logger logger = LoggerFactory.getLogger(ContentProcessorPipelineImpl.class);
    protected List<ContentProcessor> _chain = null;

    public void processContent(PipelineContent content, ResultTO result) throws ContentProcessException {
        if (this._chain != null && this._chain.size() > 0) {
            for (ContentProcessor processor : this._chain) {
                logger.debug("Running " + content.getId() + " through " + processor.getName(), new Object[0]);
                if (processor.isProcessable(content)) {
                    processor.process(content, result);
                    continue;
                }
                logger.debug(content.getId() + " was not processed by " + processor.getName(), new Object[0]);
            }
        } else {
            logger.warn("Processor chain is empty.", new Object[0]);
        }
    }

    public void setChain(List<ContentProcessor> chain) {
        this._chain = chain;
    }
}

