/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.util.Map;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.BaseContentProcessor;
import org.dom4j.Document;
import org.dom4j.Element;

public class ExtractParamsProcessor
extends BaseContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExtractParamsProcessor.class);
    public static final String NAME = "ExtractParamsProcessor";
    protected Map<String, String> params = null;

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public ExtractParamsProcessor() {
        super(NAME);
    }

    public ExtractParamsProcessor(String name) {
        super(name);
    }

    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        if (this.params != null) {
            Element root = null;
            for (String key : this.params.keySet()) {
                String value = content.getProperty(key);
                if (value != null) continue;
                if (root == null) {
                    Document document = content.getDocument();
                    root = document.getRootElement();
                }
                value = root.valueOf((String)this.params.get(key));
                content.addProperty(key, value);
            }
        }
    }
}

