/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.BaseContentProcessor;

public class FileFolderPathProcessor
extends BaseContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileFolderPathProcessor.class);
    public static final String NAME = "FileFolderPathProcessor";

    public FileFolderPathProcessor() {
        super(NAME);
    }

    public FileFolderPathProcessor(String name) {
        super(name);
    }

    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        Map params = content.getProperties();
        String path = (String)params.get("path");
        String fileName = (String)params.get("fileName");
        String folderPath = path;
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            if (path.endsWith(fileName)) {
                folderPath = path.replace("/" + fileName, "");
            } else if (path.endsWith("index.xml")) {
                folderPath = path.replace("/index.xml", "");
            } else if (path.endsWith(".xml")) {
                folderPath = path.replace(".xml", "");
            }
        }
        params.put("folderPath", folderPath);
    }
}

