/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.InputStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.DmContentProcessor;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class FormDmContentProcessor
extends PathMatchProcessor
implements DmContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FormDmContentProcessor.class);
    public static final String NAME = "WriteContentToDmProcessor";
    protected ContentService contentService;
    protected WorkflowService workflowService;
    protected ServicesConfig servicesConfig;
    protected ObjectMetadataManager objectMetadataManager;
    protected ContentRepository contentRepository;

    public FormDmContentProcessor() {
        super(NAME);
    }

    public FormDmContentProcessor(String name) {
        super(name);
    }

    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        try {
            this.writeContent(content, result);
        }
        catch (ServiceException e) {
            logger.error("Failed to write " + content.getId(), (Exception)((Object)e), new Object[0]);
            throw new ContentProcessException("Failed to write " + content.getId(), (Exception)((Object)e));
        }
        finally {
            content.closeContentStream();
        }
    }

    protected void writeContent(PipelineContent content, ResultTO result) throws ServiceException {
        String user = content.getProperty("user");
        String site = content.getProperty("site");
        String path = content.getProperty("path");
        String fileName = content.getProperty("fileName");
        String contentType = content.getProperty("contentType");
        InputStream input = content.getContentStream();
        boolean isPreview = ContentFormatUtils.getBooleanValue((String)content.getProperty("isPreview"));
        boolean createFolders = ContentFormatUtils.getBooleanValue((String)content.getProperty("createFolders"));
        String unlockValue = content.getProperty("unlock");
        boolean unlock = StringUtils.isEmpty((CharSequence)unlockValue) || !unlockValue.equalsIgnoreCase("false");
        String parentContentPath = path;
        if (parentContentPath.endsWith("/" + fileName)) {
            parentContentPath = parentContentPath.replace("/" + fileName, "");
        } else {
            path = path + "/" + fileName;
        }
        try {
            ContentItemTO parentItem = this.contentService.getContentItem(site, parentContentPath, 0);
            boolean parentContentExists = this.contentService.contentExists(site, parentContentPath);
            if (!parentContentExists && createFolders) {
                parentItem = this.createMissingFoldersInPath(site, path, isPreview);
            }
            if (parentItem != null) {
                boolean fileExists;
                if (parentItem.getName().equals(fileName)) {
                    ContentItemTO item = this.contentService.getContentItem(site, path, 0);
                    InputStream existingContent = this.contentService.getContent(site, path);
                    this.updateFile(site, item, path, input, user, isPreview, unlock, result);
                    content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                    if (unlock) {
                        this.contentService.unLockContent(site, path);
                        logger.debug("Unlocked the content " + parentContentPath, new Object[0]);
                    }
                    return;
                }
                if (path.endsWith(".xml") && !path.endsWith("index.xml")) {
                    parentContentPath = path.substring(0, path.lastIndexOf("/"));
                    parentItem = this.contentService.getContentItem(site, parentContentPath, 0);
                }
                if (fileExists = this.contentService.contentExists(site, path)) {
                    ContentItemTO contentItem = this.contentService.getContentItem(site, path, 0);
                    InputStream existingContent = this.contentService.getContent(site, path);
                    this.updateFile(site, contentItem, path, input, user, isPreview, unlock, result);
                    content.addProperty("activityType", ActivityService.ActivityType.UPDATED.toString());
                    if (unlock) {
                        this.contentService.unLockContent(site, path);
                        logger.debug("Unlocked the content site: " + site + " path: " + path, new Object[0]);
                    }
                    return;
                }
                ContentItemTO newFileItem = this.createNewFile(site, parentItem, fileName, contentType, input, user, unlock, result);
                content.addProperty("activityType", ActivityService.ActivityType.CREATED.toString());
                return;
            }
            try {
                throw new ContentNotFoundException(path + " does not exist in site: " + site);
            }
            catch (ContentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error: ", e, new Object[0]);
                throw new ContentNotFoundException("Unexpected exception ", e);
            }
        }
        finally {
            ContentUtils.release((InputStream)input);
        }
    }

    private void updateLastEditedProperties(String site, String relativePath, String user) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("modifier", user);
        properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
        if (!this.objectMetadataManager.metadataExist(site, relativePath)) {
            this.objectMetadataManager.insertNewObjectMetadata(site, relativePath);
        }
        this.objectMetadataManager.setObjectMetadata(site, relativePath, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentItemTO createNewFile(String site, ContentItemTO parentItem, String fileName, String contentType, InputStream input, String user, boolean unlock, ResultTO result) throws ContentNotFoundException {
        ContentItemTO fileItem = null;
        if (parentItem != null) {
            String folderPath = this.fileToFolder(site, parentItem.getUri());
            try {
                this.contentService.writeContent(site, parentItem.getUri() + "/" + fileName, input);
                if (!this.objectMetadataManager.metadataExist(site, parentItem.getUri() + "/" + fileName)) {
                    this.objectMetadataManager.insertNewObjectMetadata(site, parentItem.getUri() + "/" + fileName);
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("name", fileName);
                properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
                properties.put("creator", user);
                properties.put("modifier", user);
                properties.put("owner", user);
                if (unlock) {
                    properties.put("lockOwner", "");
                } else {
                    properties.put("lockOwner", user);
                }
                this.objectMetadataManager.setObjectMetadata(site, parentItem.getUri() + "/" + fileName, properties);
                result.setCommitId(this.objectMetadataManager.getProperties(site, parentItem.getUri() + "/" + fileName).getCommitId());
            }
            catch (Exception e) {
                logger.error("Error writing new file: " + fileName, e, new Object[0]);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            if (unlock) {
                this.contentRepository.unLockItem(site, parentItem.getUri() + "/" + fileName);
            }
            fileItem = this.contentService.getContentItem(site, parentItem.getUri() + "/" + fileName, 0);
            return fileItem;
        }
        throw new ContentNotFoundException(parentItem.getUri() + " does not exist in site: " + site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFile(String site, ContentItemTO contentItem, String path, InputStream input, String user, boolean isPreview, boolean unlock, ResultTO result) throws ServiceException {
        boolean success = false;
        try {
            success = this.contentService.writeContent(site, path, input);
        }
        finally {
            ContentUtils.release((InputStream)input);
        }
        if (success) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("modifier", user);
            properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
            if (unlock) {
                properties.put("lockOwner", "");
            } else {
                properties.put("lockOwner", user);
            }
            if (!this.objectMetadataManager.metadataExist(site, path)) {
                this.objectMetadataManager.insertNewObjectMetadata(site, path);
            }
            this.objectMetadataManager.setObjectMetadata(site, path, properties);
            result.setCommitId(this.objectMetadataManager.getProperties(site, path).getCommitId());
            if (!isPreview) {
                if (this.cancelWorkflow(site, path)) {
                    this.workflowService.removeFromWorkflow(site, path, true);
                } else if (this.updateWorkFlow(site, path)) {
                    this.workflowService.updateWorkflowSandboxes(site, path);
                }
            }
        }
        if (unlock) {
            this.contentRepository.unLockItem(site, path);
            logger.debug("Unlocked the content site: " + site + " path: " + path, new Object[0]);
        } else {
            this.contentRepository.lockItem(site, path);
        }
    }

    protected boolean cancelWorkflow(String site, String path) {
        if (path.endsWith(this.servicesConfig.getLevelDescriptorName(site))) {
            return false;
        }
        List pagePatterns = this.servicesConfig.getPagePatterns(site);
        if (ContentUtils.matchesPatterns((String)path, (List)pagePatterns)) {
            return true;
        }
        List componentPatterns = this.servicesConfig.getComponentPatterns(site);
        if (ContentUtils.matchesPatterns((String)path, (List)componentPatterns)) {
            return true;
        }
        List documentPatterns = this.servicesConfig.getDocumentPatterns(site);
        if (ContentUtils.matchesPatterns((String)path, (List)documentPatterns)) {
            return true;
        }
        List displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
        return ContentUtils.matchesPatterns((String)path, (List)displayPatterns);
    }

    protected boolean updateWorkFlow(String site, String path) {
        List assetPatterns = this.servicesConfig.getAssetPatterns(site);
        return ContentUtils.matchesPatterns((String)path, (List)assetPatterns);
    }

    public ContentItemTO createMissingFoldersInPath(String site, String path, boolean isPreview) {
        String[] levels = path.split("/");
        String parentPath = "";
        ContentItemTO lastItem = null;
        for (String level : levels) {
            if (StringUtils.isEmpty((CharSequence)level) || level.endsWith(".xml")) continue;
            String currentPath = parentPath + "/" + level;
            if (!this.contentService.contentExists(site, currentPath)) {
                this.contentService.createFolder(site, parentPath, level);
            }
            parentPath = currentPath;
        }
        lastItem = this.contentService.getContentItem(site, parentPath, 0);
        return lastItem;
    }

    public String fileToFolder(String site, String path) {
        if (this.contentService.contentExists(site, path)) {
            ContentItemTO itemTO = this.contentService.getContentItem(site, path, 0);
            if (itemTO.isFolder() || itemTO.isDeleted()) {
                return path;
            }
            int index = path.lastIndexOf("/");
            String folderPath = path.substring(0, index);
            String parentFileName = itemTO.getName();
            int dotIndex = parentFileName.indexOf(".");
            String folderName = dotIndex > 0 ? parentFileName.substring(0, parentFileName.indexOf(".")) : parentFileName;
            this.contentService.createFolder(site, folderPath, folderName);
            folderPath = folderPath + "/" + folderName;
            this.contentService.moveContent(site, path, folderPath + "/" + "index.xml");
            logger.debug("Changed file to folder from " + path + " to " + folderPath, new Object[0]);
            return folderPath;
        }
        return path;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

