/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.BaseContentProcessor;

public class FormNavOrderProcessor
extends BaseContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FormNavOrderProcessor.class);
    public static final String NAME = "FormNavOrderProcessor";
    protected DmPageNavigationOrderService pageNavOrderService;

    public FormNavOrderProcessor() {
        super(NAME);
    }

    public FormNavOrderProcessor(String name) {
        super(name);
    }

    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        boolean copiedContent = Boolean.valueOf(content.getProperty("copiedContent"));
        String site = String.valueOf(content.getProperty("site"));
        String path = String.valueOf(content.getProperty("path"));
        if (copiedContent) {
            this.pageNavOrderService.addNavOrder(site, path, content.getDocument());
        } else {
            this.pageNavOrderService.updateNavOrder(site, path, content.getDocument());
        }
    }

    public DmPageNavigationOrderService getPageNavOrderService() {
        return this.pageNavOrderService;
    }

    public void setPageNavOrderService(DmPageNavigationOrderService pageNavigationOrderService) {
        this.pageNavOrderService = pageNavigationOrderService;
    }
}

