/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.util.List;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.content.pipeline.BaseContentProcessor;

public class PathMatchProcessor
extends BaseContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PathMatchProcessor.class);
    public static final String NAME = "PathMatchProcessor";
    protected List<String> _matchPaths;
    protected List<String> _unmatchPaths;

    public void setMatchPaths(List<String> matchPaths) {
        this._matchPaths = matchPaths;
    }

    public void setUnmatchPaths(List<String> unmatchPaths) {
        this._unmatchPaths = unmatchPaths;
    }

    public PathMatchProcessor() {
        super(NAME);
    }

    public PathMatchProcessor(String name) {
        super(name);
    }

    public boolean isProcessable(PipelineContent content) {
        String folderPath = content.getProperty("folderPath");
        String fileName = content.getProperty("fileName");
        String path = folderPath + "/" + fileName;
        boolean result = false;
        if (this._matchPaths != null && this._matchPaths.size() > 0) {
            for (String pathPattern : this._matchPaths) {
                if (!path.matches(pathPattern)) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        if (result && this._unmatchPaths != null && this._unmatchPaths.size() > 0) {
            for (String pathPattern : this._unmatchPaths) {
                if (!path.matches(pathPattern)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

