/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.dal;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.MariaDB4jService;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.craftercms.commons.crypto.CryptoUtils;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.validator.DbIntegrityValidator;
import org.craftercms.studio.api.v1.dal.DataSourceInitializer;
import org.craftercms.studio.api.v1.exception.DatabaseUpgradeUnsupportedVersionException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.springframework.beans.factory.DisposableBean;

public class DataSourceInitializerImpl
implements DataSourceInitializer,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceInitializerImpl.class);
    private static final String CURRENT_DB_VERSION = "3.0.17";
    private static final String DB_VERSION_3_0_0 = "3.0.0";
    private static final String DB_VERSION_2_5_X = "2.5.x";
    private static final String DB_QUERY_CHECK_SCHEMA_EXISTS = "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'crafter'";
    private static final String DB_QUERY_CHECK_META_TABLE_EXISTS = "SELECT * FROM information_schema.tables WHERE table_schema = 'crafter' AND table_name = '_meta' LIMIT 1";
    private static final String DB_QUERY_GET_META_TABLE_VERSION = "SELECT _meta.version FROM _meta LIMIT 1";
    private static final String DB_QUERY_CHECK_GROUP_TABLE_EXISTS = "SELECT * FROM information_schema.tables WHERE table_schema = 'crafter' AND table_name = 'cstudio_group' LIMIT 1";
    private static final String DB_QUERY_USE_CRAFTER = "use crafter";
    private static final String DB_QUERY_SET_ADMIN_PASSWORD = "UPDATE user SET password = '{password}' WHERE username = 'admin'";
    protected String delimiter;
    protected StudioConfiguration studioConfiguration;
    protected MariaDB4jService mariaDB4jService;
    protected DbIntegrityValidator integrityValidator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initDataSource() throws DatabaseUpgradeUnsupportedVersionException, EntitlementException {
        if (!this.isEnabled()) return;
        String configureDbScriptPath = this.getConfigureDBScriptPath();
        String createDbScriptPath = this.getCreateDBScriptPath();
        logger.debug("Get MariaDB service", new Object[0]);
        DB db = this.mariaDB4jService.getDB();
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        String dbVersion = "";
        try {
            logger.debug("Get DB connection", new Object[0]);
            Class.forName(this.studioConfiguration.getProperty("studio.db.driver"));
            conn = DriverManager.getConnection(this.studioConfiguration.getProperty("studio.db.initializer.url"));
        }
        catch (ClassNotFoundException | SQLException e) {
            logger.error("Error while getting connection to DB", e, new Object[0]);
        }
        logger.info("Configure database from script " + configureDbScriptPath, new Object[0]);
        ScriptRunner sr = new ScriptRunner(conn);
        sr.setDelimiter(this.delimiter);
        sr.setStopOnError(true);
        sr.setLogWriter(null);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(configureDbScriptPath);
        InputStreamReader reader = new InputStreamReader(is);
        try {
            sr.runScript((Reader)reader);
        }
        catch (RuntimeSqlException e) {
            logger.error("Error while running configure DB script", (Exception)((Object)e), new Object[0]);
        }
        if (conn != null) {
            try {
                logger.debug("Check if database schema already exists", new Object[0]);
                statement = conn.createStatement();
                rs = statement.executeQuery(DB_QUERY_CHECK_SCHEMA_EXISTS);
                if (rs.next()) {
                    logger.debug("Database already exists. Determine version of database", new Object[0]);
                    rs.close();
                    logger.debug("Check if _meta table exists.", new Object[0]);
                    rs = statement.executeQuery(DB_QUERY_CHECK_META_TABLE_EXISTS);
                    if (rs.next()) {
                        logger.debug("_meta table exists.", new Object[0]);
                        statement.execute(DB_QUERY_USE_CRAFTER);
                        rs.close();
                        logger.debug("Get version from _meta table.", new Object[0]);
                        rs = statement.executeQuery(DB_QUERY_GET_META_TABLE_VERSION);
                        if (!rs.next()) throw new DatabaseUpgradeUnsupportedVersionException("Could not determine database version from _meta table");
                        dbVersion = rs.getString(1);
                    } else {
                        logger.debug("Check if group table exists.", new Object[0]);
                        rs = statement.executeQuery(DB_QUERY_CHECK_GROUP_TABLE_EXISTS);
                        if (rs.next()) {
                            logger.debug("Detabase version is 3.0.0", new Object[0]);
                            dbVersion = DB_VERSION_3_0_0;
                        } else {
                            logger.debug("Detabase version is 2.5.X", new Object[0]);
                            dbVersion = DB_VERSION_2_5_X;
                        }
                    }
                    switch (dbVersion) {
                        case "3.0.17": {
                            logger.info("Database is up to date.", new Object[0]);
                            this.integrityValidator.validate(conn);
                            break;
                        }
                        case "2.5.x": {
                            throw new DatabaseUpgradeUnsupportedVersionException("Automated migration from 2.5.x DB is not supported yet.");
                        }
                        default: {
                            logger.info("Database version is " + dbVersion + ", required version is " + CURRENT_DB_VERSION, new Object[0]);
                            String upgradeScriptPath = this.getUpgradeDBScriptPath();
                            upgradeScriptPath = upgradeScriptPath.replace("{version}", dbVersion);
                            logger.info("Upgrading database from script " + upgradeScriptPath, new Object[0]);
                            sr = new ScriptRunner(conn);
                            sr.setDelimiter(this.delimiter);
                            sr.setStopOnError(true);
                            sr.setLogWriter(null);
                            is = this.getClass().getClassLoader().getResourceAsStream(upgradeScriptPath);
                            reader = new InputStreamReader(is);
                            try {
                                sr.runScript((Reader)reader);
                                this.integrityValidator.store(conn);
                            }
                            catch (RuntimeSqlException e) {
                                logger.error("Error while running upgrade DB script", (Exception)((Object)e), new Object[0]);
                            }
                            break;
                        }
                    }
                } else {
                    logger.info("Database does not exists.", new Object[0]);
                    logger.info("Creating database from script " + createDbScriptPath, new Object[0]);
                    sr = new ScriptRunner(conn);
                    sr.setDelimiter(this.delimiter);
                    sr.setStopOnError(true);
                    sr.setLogWriter(null);
                    is = this.getClass().getClassLoader().getResourceAsStream(createDbScriptPath);
                    reader = new InputStreamReader(is);
                    try {
                        sr.runScript((Reader)reader);
                        if (this.isRandomAdminPasswordEnabled()) {
                            String randomPassword = this.generateRandomPassword();
                            String hashedPassword = CryptoUtils.hashPassword((String)randomPassword);
                            String update = DB_QUERY_SET_ADMIN_PASSWORD.replace("{password}", hashedPassword);
                            statement.executeUpdate(update);
                            conn.commit();
                            logger.info("*** Admin Account Password: \"" + randomPassword + "\" ***", new Object[0]);
                        }
                        this.integrityValidator.store(conn);
                    }
                    catch (RuntimeSqlException e) {
                        logger.error("Error while running create DB script", (Exception)((Object)e), new Object[0]);
                    }
                }
                rs.close();
                statement.close();
            }
            catch (SQLException e) {
                logger.error("Error while initializing database", (Exception)e, new Object[0]);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    logger.error("Error while closing database resources", (Exception)e, new Object[0]);
                }
            }
        }
        try {
            if (conn == null) return;
            conn.close();
            return;
        }
        catch (SQLException e) {
            logger.error("Error while closing connection with database", (Exception)e, new Object[0]);
        }
    }

    public boolean isEnabled() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.db.initializer.enabled"));
        return toReturn;
    }

    public void shutdown() {
        if (this.mariaDB4jService != null) {
            DB db = this.mariaDB4jService.getDB();
            if (db != null) {
                try {
                    db.stop();
                }
                catch (ManagedProcessException e) {
                    logger.error("Failed to stop database", (Exception)((Object)e), new Object[0]);
                }
            }
            try {
                this.mariaDB4jService.stop();
            }
            catch (ManagedProcessException e) {
                logger.error("Failed to stop database", (Exception)((Object)e), new Object[0]);
            }
        }
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                logger.error("Failed to unregister driver " + driver.getClass().getCanonicalName() + " on shutdown", (Exception)e, new Object[0]);
            }
        }
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    private String generateRandomPassword() {
        int passwordLength = Integer.parseInt(this.studioConfiguration.getProperty("studio.db.initializer.randomAdminPassword.length"));
        String passwordChars = this.studioConfiguration.getProperty("studio.db.initializer.randomAdminPassword.chars");
        return RandomStringUtils.random((int)passwordLength, (String)passwordChars);
    }

    private String getConfigureDBScriptPath() {
        return this.studioConfiguration.getProperty("studio.db.initializer.configureDbscriptLocation");
    }

    private String getCreateDBScriptPath() {
        return this.studioConfiguration.getProperty("studio.db.initializer.createDbscriptLocation");
    }

    private String getUpgradeDBScriptPath() {
        return this.studioConfiguration.getProperty("studio.db.initializer.upgradeDbScriptLocation");
    }

    private boolean isRandomAdminPasswordEnabled() {
        boolean toRet = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.db.initializer.randomAdminPassword.enabled"));
        return toRet;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public MariaDB4jService getMariaDB4jService() {
        return this.mariaDB4jService;
    }

    public void setMariaDB4jService(MariaDB4jService mariaDB4jService) {
        this.mariaDB4jService = mariaDB4jService;
    }

    public void setIntegrityValidator(DbIntegrityValidator integrityValidator) {
        this.integrityValidator = integrityValidator;
    }
}

