/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;

public class EnvironmentStoreDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentStoreDeployer.class);
    protected String environmentsStoreRootPath;
    protected ContentService contentService;
    protected String environment;

    public void deployFile(String site, String path) {
        InputStream content = null;
        try {
            content = this.contentService.getContent(site, path);
            this.writeFile(site, path, this.environment, content);
        }
        catch (ContentNotFoundException e) {
            logger.error("Deployment to environment store failed [{0}]. Content not found for [{1}:{2}]", (Exception)((Object)e), new Object[]{this.environment, site, path});
        }
    }

    private void writeFile(String site, String path, String environment, InputStream content) {
        try {
            if (content == null || content.available() < 0) {
                logger.warn("Not able to write empty content to environment store for site: {0}, path: {1}, environment: {2}", new Object[]{site, path, environment});
                return;
            }
            File file = new File(this.getDestinationPath(site, path, environment));
            logger.debug("Writing file: " + file.getAbsolutePath(), new Object[0]);
            FileUtils.copyInputStreamToFile((InputStream)content, (File)file);
        }
        catch (IOException e) {
            logger.error("Error while saving content to environment store [site: {0}] [path: {1}] [envirnonment: {2}]", (Exception)e, new Object[]{site, path, environment});
        }
    }

    private String getDestinationPath(String site, String path, String environment) {
        return String.format("%s/%s/%s/%s", this.environmentsStoreRootPath, site, environment, path);
    }

    public void deployFiles(String site, List<String> paths) {
    }

    public void deleteFile(String site, String path) {
        File file = new File(this.getDestinationPath(site, path, this.environment));
        file.delete();
    }

    public void deleteFiles(String site, List<String> paths) {
    }

    public void deployFiles(String site, List<String> paths, List<String> deletedFiles) {
    }

    public String getEnvironmentsStoreRootPath() {
        return this.environmentsStoreRootPath;
    }

    public void setEnvironmentsStoreRootPath(String environmentsStoreRootPath) {
        this.environmentsStoreRootPath = environmentsStoreRootPath;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }
}

