/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.deployment.ContentNotFoundForPublishingException;
import org.craftercms.studio.api.v1.service.deployment.UploadFailedException;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class EnvironmentStoreGitBranchDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentStoreGitBranchDeployer.class);
    protected String environmentsStoreRootPath;
    protected ContentService contentService;
    protected String environment;
    protected String rootPath;

    public void deployFile(String site, String path) {
        Repository repository = this.cloneSiteRepository(site);
        if (repository != null) {
            this.checkoutEnvironment(repository, site);
            this.createPatch(repository, site, path);
            this.applyPatch(repository, site);
            this.pushChanges(repository);
            this.cleanup(site);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Repository cloneSiteRepository(String site) {
        Path siteEnvironmentStoreRepoPath = Paths.get(this.environmentsStoreRootPath, site);
        File localPath = siteEnvironmentStoreRepoPath.toFile();
        try {
            FileUtils.deleteDirectory((File)localPath);
        }
        catch (IOException e) {
            logger.error("Error deleting directory " + localPath.toString(), new Object[0]);
        }
        Path siteRepoPath = Paths.get(this.rootPath, "sites", site, ".git");
        try (Git result = Git.cloneRepository().setURI(siteRepoPath.toAbsolutePath().normalize().toString()).setDirectory(localPath).call();){
            Repository repository = result.getRepository();
            return repository;
        }
        catch (GitAPIException e) {
            logger.error("Error cloning repository for site " + site, (Exception)((Object)e), new Object[0]);
            return null;
        }
    }

    private void checkoutEnvironment(Repository repository, String site) {
        Git git = null;
        try {
            Ref branchRef = repository.findRef(this.environment);
            git = new Git(repository);
            git.checkout().setCreateBranch(true).setName(this.environment).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + this.environment).call();
            git.fetch().call();
            git.pull().call();
        }
        catch (RefNotFoundException e) {
            try {
                git.checkout().setOrphan(true).setName(this.environment).call();
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.command("git", "rm", "-rf", ".");
                pb.directory(repository.getDirectory().getParentFile());
                Process p = pb.start();
                p.waitFor();
                git.commit().setMessage("initial content").setAllowEmpty(true).call();
            }
            catch (IOException | InterruptedException | GitAPIException e1) {
                logger.error("Error checking out environment store branch for site " + site + " environment " + this.environment, (Exception)e1, new Object[0]);
            }
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error checking out environment store branch for site " + site + " environment " + this.environment, (Exception)e, new Object[0]);
        }
    }

    private void applyPatch(Repository envStoreRepo, String site) {
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            tempPath = "temp";
        }
        Path patchPath = Paths.get(tempPath, "patch" + site + ".bin");
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("git", "apply", patchPath.toAbsolutePath().normalize().toString());
            pb.directory(envStoreRepo.getDirectory().getParentFile());
            Process p = pb.start();
            p.waitFor();
        }
        catch (Exception e) {
            logger.error("Error applying patch for site: " + site, e, new Object[0]);
        }
    }

    private void createPatch(Repository repository, String site, String path) {
        StringBuffer output = new StringBuffer();
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            tempPath = "temp";
        }
        Path patchPath = Paths.get(tempPath, "patch" + site + ".bin");
        String gitPath = this.getGitPath(path);
        Process p = null;
        File file = patchPath.toAbsolutePath().normalize().toFile();
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("git", "diff", "--binary", this.environment, "master", "--", gitPath);
            pb.redirectOutput(file);
            pb.directory(repository.getDirectory().getParentFile());
            p = pb.start();
            p.waitFor();
        }
        catch (Exception e) {
            logger.error("Error while creating patch for site: " + site + " path: " + path, e, new Object[0]);
        }
    }

    private void pushChanges(Repository repository) {
        Git git = new Git(repository);
        try {
            git.add().addFilepattern(".").call();
            git.commit().setMessage("deployment to environment store").call();
            git.push().call();
        }
        catch (GitAPIException e) {
            logger.error("Error while pushing workflow changes.", (Exception)((Object)e), new Object[0]);
        }
    }

    private void cleanup(String site) {
        Path siteEnvironmentStoreRepoPath = Paths.get(this.environmentsStoreRootPath, site);
        File localPath = siteEnvironmentStoreRepoPath.toFile();
        try {
            FileUtils.deleteDirectory((File)localPath);
        }
        catch (IOException e) {
            logger.error("Error deleting directory " + localPath.toString(), new Object[0]);
        }
    }

    private Repository getEnvironmentStoreRepositoryInstance(String site) throws IOException {
        Repository envStoreRepo;
        Path siteRepoPath = Paths.get(this.environmentsStoreRootPath, site, this.environment, ".git").toAbsolutePath();
        if (!Files.exists(siteRepoPath, new LinkOption[0])) {
            this.createEnvironmentStoreRepository(site);
        }
        if (!this.checkIfWorkAreaAddedAsRemote(envStoreRepo = this.openGitRepository(siteRepoPath))) {
            this.addWorkAreaRemote(site, envStoreRepo);
        }
        return envStoreRepo;
    }

    private boolean createEnvironmentStoreRepository(String site) {
        boolean success = true;
        Path siteEnvironmentStoreRepoPath = Paths.get(this.environmentsStoreRootPath, site, this.environment);
        try {
            Files.deleteIfExists(siteEnvironmentStoreRepoPath);
            siteEnvironmentStoreRepoPath = Paths.get(this.environmentsStoreRootPath, site, this.environment, ".git");
            try (Repository repository = FileRepositoryBuilder.create((File)siteEnvironmentStoreRepoPath.toFile());){
                repository.create();
                Git git = new Git(repository);
                git.add().addFilepattern(".").call();
                RevCommit revCommit = git.commit().setMessage("initial content").setAllowEmpty(true).call();
            }
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error while creating repository for site " + site, (Exception)e, new Object[0]);
            success = false;
        }
        return success;
    }

    private void addWorkAreaRemote(String site, Repository envStoreRepo) {
        envStoreRepo.getRemoteName("work-area");
        Git git = new Git(envStoreRepo);
        StoredConfig config = git.getRepository().getConfig();
        Path siteRepoPath = Paths.get(this.rootPath, "sites", site, ".git");
        config.setString("remote", "work-area", "url", siteRepoPath.normalize().toAbsolutePath().toString());
        try {
            config.save();
        }
        catch (IOException e) {
            logger.error("Error adding work area as remote for environment store.", (Exception)e, new Object[0]);
        }
    }

    private boolean checkIfWorkAreaAddedAsRemote(Repository repository) {
        boolean exists = false;
        try {
            StoredConfig storedConfig = repository.getConfig();
            Set remotes = storedConfig.getSubsections("remote");
            for (String remoteName : remotes) {
                logger.debug("Remote: " + remoteName, new Object[0]);
                if (!remoteName.equals("work-area")) continue;
                exists = true;
                break;
            }
        }
        catch (Exception err) {
            logger.error("Error while reading remotes info.", err, new Object[0]);
        }
        return exists;
    }

    private String getGitPath(String path) {
        String gitPath = FilenameUtils.normalize((String)path, (boolean)true);
        gitPath = gitPath.replaceAll("^/", "");
        return gitPath;
    }

    private Repository openGitRepository(Path repositoryPath) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(repositoryPath.toFile())).readEnvironment()).findGitDir()).build();
        return repository;
    }

    public void deployFiles(String site, List<String> paths) {
    }

    public void deployFiles(String site, List<String> paths, List<String> deletedFiles) throws ContentNotFoundForPublishingException, UploadFailedException {
    }

    public void deleteFile(String site, String path) {
        try {
            Repository repo = this.getEnvironmentStoreRepositoryInstance(site);
            Git git = new Git(repo);
            git.rm().addFilepattern(this.getGitPath(path)).setCached(false).call();
            RevCommit revCommit = git.commit().setOnly(this.getGitPath(path)).setMessage("").call();
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            logger.error("Error while deleting content from environment store for site: " + site + " path: " + path + " environment: " + this.environment, (Exception)e, new Object[0]);
        }
    }

    public void deleteFiles(String site, List<String> paths) {
    }

    public String getEnvironmentsStoreRootPath() {
        return this.environmentsStoreRootPath;
    }

    public void setEnvironmentsStoreRootPath(String environmentsStoreRootPath) {
        this.environmentsStoreRootPath = environmentsStoreRootPath;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }
}

