/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.deployment.ContentNotFoundForPublishingException;
import org.craftercms.studio.api.v1.service.deployment.UploadFailedException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class EnvironmentStoreGitDeployer
implements Deployer {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentStoreGitDeployer.class);
    protected String environmentsStoreRootPath;
    protected ContentService contentService;
    protected String environment;
    protected String rootPath;

    public void deployFile(String site, String path) {
        try (Repository envStoreRepo = this.getEnvironmentStoreRepositoryInstance(site);){
            this.fetchFromRemote(site, envStoreRepo);
            this.createPatch(envStoreRepo, site, path);
            Git git = new Git(envStoreRepo);
            this.applyPatch(envStoreRepo, site);
            git.add().addFilepattern(".").call();
            git.commit().setMessage("deployment").call();
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error while deploying file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
    }

    private void applyPatch(Repository envStoreRepo, String site) {
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            tempPath = "temp";
        }
        Path patchPath = Paths.get(tempPath, "patch" + site + ".bin");
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("git", "apply", patchPath.toAbsolutePath().normalize().toString());
            pb.directory(envStoreRepo.getDirectory().getParentFile());
            Process p = pb.start();
            int code = p.waitFor();
            int code2 = p.exitValue();
            logger.debug("Apply patch exited with code: " + code + " " + code2, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error applying patch for site: " + site, e, new Object[0]);
        }
    }

    private void fetchFromRemote(String site, Repository repository) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("git", "fetch", "work-area");
            pb.directory(repository.getDirectory().getParentFile());
            Process p = pb.start();
            int code = p.waitFor();
            int code2 = p.exitValue();
            logger.debug("Fetch exit with code: " + code + " " + code2, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error while fetching from work-area  for site: " + site, e, new Object[0]);
        }
    }

    private InputStream createPatch(Repository repository, String site, String path) {
        StringBuffer output = new StringBuffer();
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            tempPath = "temp";
        }
        Path patchPath = Paths.get(tempPath, "patch" + site + ".bin");
        String gitPath = this.getGitPath(path);
        Process p = null;
        File file = patchPath.toAbsolutePath().normalize().toFile();
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("git", "diff", "--binary", "HEAD", "FETCH_HEAD", "--", gitPath);
            pb.redirectOutput(file);
            pb.directory(repository.getDirectory().getParentFile());
            p = pb.start();
            int code = p.waitFor();
            int code2 = p.exitValue();
            logger.debug("Create patch exit with code: " + code + " " + code2, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error while creating patch for site: " + site + " path: " + path, e, new Object[0]);
        }
        return null;
    }

    private Repository getEnvironmentStoreRepositoryInstance(String site) throws IOException {
        Repository envStoreRepo;
        Path siteRepoPath = Paths.get(this.environmentsStoreRootPath, site, this.environment, ".git").toAbsolutePath();
        if (!Files.exists(siteRepoPath, new LinkOption[0])) {
            this.createEnvironmentStoreRepository(site);
        }
        if (!this.checkIfWorkAreaAddedAsRemote(envStoreRepo = this.openGitRepository(siteRepoPath))) {
            this.addWorkAreaRemote(site, envStoreRepo);
        }
        return envStoreRepo;
    }

    private boolean createEnvironmentStoreRepository(String site) {
        boolean success = true;
        Path siteEnvironmentStoreRepoPath = Paths.get(this.environmentsStoreRootPath, site, this.environment);
        try {
            Files.deleteIfExists(siteEnvironmentStoreRepoPath);
            siteEnvironmentStoreRepoPath = Paths.get(this.environmentsStoreRootPath, site, this.environment, ".git");
            try (Repository repository = FileRepositoryBuilder.create((File)siteEnvironmentStoreRepoPath.toFile());){
                repository.create();
                Git git = new Git(repository);
                git.add().addFilepattern(".").call();
                RevCommit revCommit = git.commit().setMessage("initial content").setAllowEmpty(true).call();
            }
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error while creating repository for site " + site, (Exception)e, new Object[0]);
            success = false;
        }
        return success;
    }

    private void addWorkAreaRemote(String site, Repository envStoreRepo) {
        envStoreRepo.getRemoteName("work-area");
        Git git = new Git(envStoreRepo);
        StoredConfig config = git.getRepository().getConfig();
        Path siteRepoPath = Paths.get(this.rootPath, "sites", site, ".git");
        config.setString("remote", "work-area", "url", siteRepoPath.normalize().toAbsolutePath().toString());
        try {
            config.save();
        }
        catch (IOException e) {
            logger.error("Error adding work area as remote for environment store.", (Exception)e, new Object[0]);
        }
    }

    private boolean checkIfWorkAreaAddedAsRemote(Repository repository) {
        boolean exists = false;
        try {
            StoredConfig storedConfig = repository.getConfig();
            Set remotes = storedConfig.getSubsections("remote");
            for (String remoteName : remotes) {
                logger.debug("Remote: " + remoteName, new Object[0]);
                if (!remoteName.equals("work-area")) continue;
                exists = true;
                break;
            }
        }
        catch (Exception err) {
            logger.error("Error while reading remotes info.", err, new Object[0]);
        }
        return exists;
    }

    private String getGitPath(String path) {
        String gitPath = FilenameUtils.normalize((String)path, (boolean)true);
        gitPath = gitPath.replaceAll("^/", "");
        return gitPath;
    }

    private Repository openGitRepository(Path repositoryPath) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(repositoryPath.toFile())).readEnvironment()).findGitDir()).build();
        return repository;
    }

    public void deployFiles(String site, List<String> paths) {
    }

    public void deployFiles(String site, List<String> paths, List<String> deletedFiles) throws ContentNotFoundForPublishingException, UploadFailedException {
    }

    public void deleteFile(String site, String path) {
        try {
            Repository repo = this.getEnvironmentStoreRepositoryInstance(site);
            Git git = new Git(repo);
            git.rm().addFilepattern(this.getGitPath(path)).setCached(false).call();
            RevCommit revCommit = git.commit().setOnly(this.getGitPath(path)).setMessage("").call();
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            logger.error("Error while deleting content from environment store for site: " + site + " path: " + path + " environment: " + this.environment, (Exception)e, new Object[0]);
        }
    }

    public void deleteFiles(String site, List<String> paths) {
    }

    public String getEnvironmentsStoreRootPath() {
        return this.environmentsStoreRootPath;
    }

    public void setEnvironmentsStoreRootPath(String environmentsStoreRootPath) {
        this.environmentsStoreRootPath = environmentsStoreRootPath;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }
}

