/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.craftercms.studio.api.v1.deployment.PreviewDeployer;
import org.craftercms.studio.api.v1.ebus.EventListener;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.deployment.PreviewDeployerImpl;
import org.springframework.http.HttpStatus;

public class PreviewDeployerImpl
implements PreviewDeployer {
    private static final Logger logger = LoggerFactory.getLogger(PreviewDeployerImpl.class);
    private static final String METHOD_PREVIEW_SYNC_LISTENER = "onPreviewSync";
    protected CloseableHttpClient httpClient;
    protected StudioConfiguration studioConfiguration;
    protected EventService eventService;
    protected String beanName;

    public PreviewDeployerImpl() {
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(requestConfig).build();
    }

    public void subscribeToPreviewSyncEvents() {
        try {
            Method subscribeMethod = PreviewDeployerImpl.class.getMethod(METHOD_PREVIEW_SYNC_LISTENER, PreviewEventContext.class);
            this.eventService.subscribe("studio.event.previewSync", this.beanName, subscribeMethod);
        }
        catch (NoSuchMethodException e) {
            logger.error("Could not subscribe to preview sync events", (Exception)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={"studio.event.previewSync"})
    public void onPreviewSync(PreviewEventContext context) {
        String site = context.getSite();
        String requestUrl = this.getDeployTargetUrl(site);
        HttpPost postRequest = new HttpPost(requestUrl);
        if (context.isWaitTillDeploymentIsDone()) {
            String requestBody = this.getDeployTargetRequestBody(true);
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            postRequest.setEntity((HttpEntity)requestEntity);
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            HttpStatus httpStatus = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
            if (!httpStatus.is2xxSuccessful()) {
                logger.error("Preview sync request for site " + site + " returned status " + httpStatus + " (" + httpStatus.getReasonPhrase() + ")", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error while sending preview sync request for site " + site, (Exception)e, new Object[0]);
        }
        finally {
            postRequest.releaseConnection();
        }
    }

    private String getDeployTargetUrl(String site) {
        String toRet = this.studioConfiguration.getProperty("studio.preview.defaultPreviewDeployerUrl").replaceAll("\\{siteName\\}", site);
        return toRet;
    }

    private String getDeployTargetRequestBody(boolean waitTillDone) {
        DeployTargetRequestBody requestBody = new DeployTargetRequestBody(this);
        requestBody.setWaitTillDone(waitTillDone);
        return requestBody.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTarget(String site) {
        boolean toReturn = true;
        String requestUrl = this.getCreateTargetUrl();
        HttpPost postRequest = new HttpPost(requestUrl);
        String requestBody = this.getCreateTargetRequestBody(site);
        StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
        postRequest.setEntity((HttpEntity)requestEntity);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()) != HttpStatus.CREATED) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending preview sync request for site " + site, (Exception)e, new Object[0]);
            toReturn = false;
        }
        finally {
            postRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getCreateTargetUrl() {
        String toReturn = this.studioConfiguration.getProperty("studio.preview.createTargetUrl");
        return toReturn;
    }

    private String getCreateTargetRequestBody(String site) {
        CreateTargetRequestBody requestBody = new CreateTargetRequestBody(this);
        requestBody.setEnvironment("preview");
        requestBody.setSiteName(site);
        requestBody.setReplace(Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.preview.replace")));
        requestBody.setDisableDeployCron(Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.preview.disableDeployCron")));
        requestBody.setTemplateName(this.studioConfiguration.getProperty("studio.preview.templateName"));
        String repoUrl = this.studioConfiguration.getProperty("studio.preview.repoUrl").replaceAll("\\{siteName\\}", site);
        Path repoUrlPath = Paths.get(repoUrl, new String[0]);
        repoUrl = repoUrlPath.normalize().toAbsolutePath().toString();
        requestBody.setRepoUrl(repoUrl);
        requestBody.setEngineUrl(this.studioConfiguration.getProperty("studio.preview.engineUrl"));
        return requestBody.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTarget(String site) {
        boolean toReturn = true;
        String requestUrl = this.getDeleteTargetUrl(site);
        HttpPost postRequest = new HttpPost(requestUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (!HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()).is2xxSuccessful()) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending delete preview target request for site " + site, (Exception)e, new Object[0]);
            toReturn = false;
        }
        finally {
            postRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getDeleteTargetUrl(String site) {
        String url = new String(this.studioConfiguration.getProperty("studio.preview.deleteTargetUrl"));
        url = url.replaceAll("\\{siteName\\}", site);
        url = url.replaceAll("\\{siteEnv\\}", "preview");
        return url;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

