/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.entitlement;

import java.util.Arrays;
import java.util.List;
import org.craftercms.commons.entitlements.model.Entitlement;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.usage.EntitlementUsageProvider;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.site.SiteService;

public class StudioEntitlementUsageProvider
implements EntitlementUsageProvider {
    protected ObjectMetadataManager objectMetadataManager;
    protected SecurityProvider securityProvider;
    protected SiteService siteService;

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public Module getModule() {
        return Module.STUDIO;
    }

    public List<Entitlement> getCurrentUsage() {
        Entitlement sites = new Entitlement();
        sites.setType(EntitlementType.SITE);
        sites.setValue(this.siteService.countSites());
        Entitlement users = new Entitlement();
        users.setType(EntitlementType.USER);
        users.setValue(this.securityProvider.getAllUsersTotal());
        Entitlement items = new Entitlement();
        items.setType(EntitlementType.ITEM);
        items.setValue(this.objectMetadataManager.countAllItems());
        return Arrays.asList(sites, users, items, items);
    }
}

