/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.image.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ImageTransformationException;
import org.craftercms.studio.api.v1.image.transformation.ImageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMagickTransformer
implements ImageTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ImageMagickTransformer.class);
    private static final String DEFAULT_IMG_MGK_PATH = "convert";
    private static final int DEFAULT_PROCESS_TIMEOUT_SECS = 30;
    private static final String PARAM_OPTIONS = "options";
    private String imgMgkPath = "convert";
    private int processTimeoutSecs = 30;

    public void setImgMgkPath(String imgMgkPath) {
        this.imgMgkPath = imgMgkPath;
    }

    public void setProcessTimeoutSecs(int processTimeoutSecs) {
        this.processTimeoutSecs = processTimeoutSecs;
    }

    public void transform(Path sourcePath, Path targetPath, Map<String, String> parameters) throws ImageTransformationException {
        String cmdLine = this.createCmdLine(sourcePath, targetPath, parameters);
        try {
            logger.info("Executing command: {}", (Object)cmdLine);
            Process proc = Runtime.getRuntime().exec(cmdLine);
            proc.waitFor(this.processTimeoutSecs, TimeUnit.SECONDS);
            String stdOut = this.getProcessStdOut(proc);
            String stdErr = this.getProcessStdErr(proc);
            if (StringUtils.isNotEmpty((CharSequence)stdOut)) {
                logger.info("Img Mgk stdout for [{}]: {}", (Object)cmdLine, (Object)stdOut);
            }
            if (StringUtils.isNotEmpty((CharSequence)stdErr)) {
                logger.info("Img Mgk stderr for [{}]: {}", (Object)cmdLine, (Object)stdErr);
            }
        }
        catch (Exception e) {
            throw new ImageTransformationException("Error while running Image Magick process from the command line", e);
        }
    }

    private String createCmdLine(Path sourcePath, Path targetPath, Map<String, String> parameters) {
        StringBuilder cmdLine = new StringBuilder(this.imgMgkPath);
        cmdLine.append(" ").append(sourcePath.toAbsolutePath().toString());
        String options = MapUtils.getString(parameters, (Object)PARAM_OPTIONS);
        if (StringUtils.isNotEmpty((CharSequence)options)) {
            cmdLine.append(" ").append(options);
        }
        cmdLine.append(" ").append(targetPath.toAbsolutePath().toString());
        return cmdLine.toString();
    }

    private String getProcessStdOut(Process proc) throws IOException {
        return IOUtils.toString((InputStream)proc.getInputStream(), (Charset)Charset.defaultCharset());
    }

    private String getProcessStdErr(Process proc) throws IOException {
        return IOUtils.toString((InputStream)proc.getErrorStream(), (Charset)Charset.defaultCharset());
    }
}

