/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.job;

import java.util.List;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.EmailMessageQueueTo;
import org.craftercms.studio.api.v1.to.EmailMessageTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.job.EmailMessageSender;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailMessageSender
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EmailMessageSender.class);
    protected JavaMailSender emailService;
    protected JavaMailSender emailServiceNoAuth;
    protected EmailMessageQueueTo emailMessages;
    protected StudioConfiguration studioConfiguration;
    private Thread thread;
    private boolean running;

    public String getDefaultFromAddress() {
        return this.studioConfiguration.getProperty("studio.mail.from.default");
    }

    public void initThread() {
        this.thread = new Thread((Runnable)this);
        this.running = true;
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                if (this.emailMessages.size() > 0) {
                    List list = this.emailMessages.getAll();
                    int size = list.size();
                    for (int counter = 0; counter < size; ++counter) {
                        EmailMessageTO emailMessage = (EmailMessageTO)list.get(counter);
                        emailMessage.preprocessEmail();
                        String userEmailAddress = emailMessage.getTo();
                        String content = emailMessage.getContent();
                        String subject = emailMessage.getSubject();
                        String replyTo = emailMessage.getReplyTo();
                        String personalFromName = emailMessage.getPersonalFromName();
                        boolean success = this.sendEmail(subject, content, userEmailAddress, replyTo, personalFromName);
                        if (success) {
                            logger.debug("Successfully sent email to:" + userEmailAddress, new Object[0]);
                        } else {
                            logger.error("Could not send email to:" + userEmailAddress, new Object[0]);
                        }
                        emailMessage = null;
                    }
                }
                int secs = 30;
                Thread.sleep((long)secs * 1000L);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while Thread.sleep()", new Object[]{e});
                Thread.currentThread().interrupt();
            }
        }
    }

    protected boolean sendEmail(String subject, String content, String userEmailAddress, String replyTo, String personalFromName) {
        boolean success = true;
        1 preparator = new /* Unavailable Anonymous Inner Class!! */;
        try {
            if (this.isAuthenticatedSMTP()) {
                this.emailService.send((MimeMessagePreparator)preparator);
            } else {
                this.emailServiceNoAuth.send((MimeMessagePreparator)preparator);
            }
        }
        catch (MailException ex) {
            logger.error("Error sending email notification to:" + userEmailAddress, (Exception)((Object)ex), new Object[0]);
            success = false;
        }
        return success;
    }

    public void shutdown() {
        if (this.thread != null) {
            this.running = false;
            this.thread.interrupt();
        }
    }

    public boolean isAuthenticatedSMTP() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.mail.smtp.auth"));
        return toReturn;
    }

    public JavaMailSender getEmailService() {
        return this.emailService;
    }

    public void setEmailService(JavaMailSender emailService) {
        this.emailService = emailService;
    }

    public void setEmailMessages(EmailMessageQueueTo emailMessages) {
        this.emailMessages = emailMessages;
    }

    public JavaMailSender getEmailServiceNoAuth() {
        return this.emailServiceNoAuth;
    }

    public void setEmailServiceNoAuth(JavaMailSender emailServiceNoAuth) {
        this.emailServiceNoAuth = emailServiceNoAuth;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

