/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.log.l4j;

import org.craftercms.studio.api.v1.log.AbstractLogger;
import org.slf4j.Logger;

public class LoggerImpl
extends AbstractLogger {
    protected Logger _logger;

    public String getName() {
        return this._logger.getName();
    }

    public String getLevel() {
        String retLevel = "off";
        if (this._logger.isErrorEnabled()) {
            retLevel = "error";
        }
        if (this._logger.isWarnEnabled()) {
            retLevel = "warn";
        }
        if (this._logger.isInfoEnabled()) {
            retLevel = "info";
        }
        if (this._logger.isDebugEnabled()) {
            retLevel = "debug";
        }
        if (this._logger.isTraceEnabled()) {
            retLevel = "trace";
        }
        return retLevel;
    }

    public void debug(String msg, Object ... args) {
        if (this._logger.isDebugEnabled()) {
            String message = this.expandMessage(msg, args);
            this._logger.debug(message);
        }
    }

    public void warn(String msg, Object ... args) {
        if (this._logger.isWarnEnabled()) {
            String message = this.expandMessage(msg, args);
            this._logger.warn(message);
        }
    }

    public void info(String msg, Object ... args) {
        if (this._logger.isInfoEnabled()) {
            String message = this.expandMessage(msg, args);
            this._logger.info(message);
        }
    }

    public void error(String msg, Object ... args) {
        if (this._logger.isErrorEnabled()) {
            String message = this.expandMessage(msg, args);
            this._logger.error(message);
        }
    }

    public void error(String msg, Exception err, Object ... args) {
        if (this._logger.isErrorEnabled()) {
            String message = this.expandMessage(msg, args);
            this._logger.error(message, (Throwable)err);
        }
    }

    LoggerImpl(Logger logger) {
        this._logger = logger;
    }
}

